/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.mclauncherlib.utils.files;

import fr.aventuros.mclauncherlib.utils.files.ExtensionFilter;
import fr.aventuros.mclauncherlib.utils.files.FileListerFilter;
import fr.aventuros.mclauncherlib.utils.files.FileTypeFilter;
import fr.aventuros.mclauncherlib.utils.files.RegexFilter;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class FileLister {
    private final File base;
    private ArrayList<FileListerFilter> filters = new ArrayList();

    public FileLister(File base) {
        this.base = base;
    }

    public FileLister addFilter(FileListerFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public FileLister onlyDirs() {
        return this.addFilter(new FileTypeFilter(true));
    }

    public FileLister onlyFiles() {
        return this.addFilter(new FileTypeFilter(false));
    }

    public FileLister matches(Pattern pattern) {
        return this.addFilter(new RegexFilter(pattern));
    }

    public FileLister withExtension(String extension) {
        return this.addFilter(new ExtensionFilter(extension));
    }

    public List<File> buildList() {
        ArrayDeque<File> queue = new ArrayDeque<File>();
        queue.add(this.base);
        ArrayList<File> files = new ArrayList<File>();
        block0: while (!queue.isEmpty()) {
            File[] subFiles;
            File file = (File)queue.removeFirst();
            if (file.isDirectory() && (subFiles = file.listFiles()) != null) {
                List<File> subFilesList = Arrays.asList(subFiles);
                Collections.reverse(subFilesList);
                queue.addAll(subFilesList);
            }
            for (FileListerFilter filter : this.filters) {
                if (filter.include(file)) continue;
                continue block0;
            }
            files.add(file);
        }
        return files;
    }
}

