/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.mclauncherlib.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.IntConsumer;

public class FileDownloader {
    private final String downloadURL;

    public FileDownloader(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public InputStream downloadStream() throws IOException {
        int i = 0;
        while (true) {
            URL url = new URL(this.downloadURL);
            URLConnection conn = url.openConnection();
            try {
                return conn.getInputStream();
            }
            catch (IOException e) {
                IOException err = e;
                System.err.printf("Erreur r\u00e9seau lors du t\u00e9l\u00e9chargement de %s, essai n\u00b0%d%n", this.downloadURL, ++i);
                if (i < 3) continue;
                throw err;
            }
            break;
        }
    }

    public BufferedReader downloadReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.downloadStream()));
    }

    public void downloadToOutputStream(OutputStream outputStream) throws IOException {
        this.downloadToOutputStream(outputStream, null);
    }

    public void downloadToOutputStream(OutputStream outputStream, IntConsumer downloadPartCallback) throws IOException {
        try (InputStream stream = this.downloadStream();){
            int size;
            byte[] buffer = new byte[4096];
            while ((size = stream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, size);
                if (downloadPartCallback == null) continue;
                downloadPartCallback.accept(size);
            }
        }
    }

    public byte[] downloadBytes() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.downloadToOutputStream(outputStream, null);
        return outputStream.toByteArray();
    }

    public String downloadString(Charset charset) throws IOException {
        return new String(this.downloadBytes(), charset);
    }

    public String downloadString() throws IOException {
        return new String(this.downloadBytes(), StandardCharsets.UTF_8);
    }

    public File downloadToFile(File destinationFile) throws IOException {
        return this.downloadToFile(destinationFile, null);
    }

    public File downloadToFile(File destinationFile, IntConsumer downloadPartCallback) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            this.downloadToOutputStream(fos, downloadPartCallback);
        }
        return destinationFile;
    }
}

