/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.mclauncherlib.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;

public class ErrorCatcher {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final DateFormat dateFormatFileSafe = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final String productName;
    private final String filename;
    private final File dir;

    public ErrorCatcher(String productName, String filename, File dir) {
        this.productName = productName;
        this.filename = filename;
        this.dir = dir;
    }

    public File writeError(String errorReport, Date date) throws IOException {
        File file = new File(this.dir, String.format("report_%s_%s.log", dateFormatFileSafe.format(date), this.filename));
        System.err.println("\u00c9criture du rapport d'erreur dans " + file.getAbsolutePath());
        this.dir.mkdirs();
        FileWriter fw = new FileWriter(file);
        fw.write(errorReport);
        fw.close();
        return file;
    }

    public String formatStackTrace(Throwable e) {
        StringBuilder builder = new StringBuilder();
        builder.append("# ").append(e);
        for (StackTraceElement element : e.getStackTrace()) {
            builder.append("\n#     ").append(element);
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            builder.append("\n# Caused by: ").append(this.formatStackTrace(cause).substring(2));
        }
        return builder.toString();
    }

    public String makeErrorReport(Throwable e, Date date) {
        return "# " + this.productName + " Error Report\n# At : " + dateFormat.format(date) + "\n# Exception : " + e.getClass().getSimpleName() + "\n\n" + this.formatStackTrace(e);
    }

    public void catchError(Throwable e, String message) {
        System.err.println("Une erreur est survenue !");
        Date date = new Date();
        String errorReport = this.makeErrorReport(e, date);
        System.err.println(errorReport);
        StringBuilder dialogBuilder = new StringBuilder();
        if (message != null) {
            dialogBuilder.append(message).append("\n");
        }
        dialogBuilder.append(e).append("\n");
        try {
            File report = this.writeError(errorReport, date);
            dialogBuilder.append("\nLe rapport d'erreur est dans : ").append(report.getAbsolutePath());
        }
        catch (IOException var5) {
            System.err.println("Impossible d'\u00e9crire le rapport d'erreur :( :");
            e.printStackTrace();
            dialogBuilder.append("\nImpossible d'\u00e9crire le rapport d'erreur :( : ").append(var5);
        }
        JOptionPane.showMessageDialog(null, dialogBuilder, "Erreur - " + this.productName, 0);
    }

    public void catchError(Throwable e) {
        this.catchError(e, null);
    }
}

