/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.mclauncherlib.filesupdater;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.aventuros.mclauncherlib.filesupdater.DownloadSource;
import fr.aventuros.mclauncherlib.filesupdater.DownloadStatus;
import fr.aventuros.mclauncherlib.filesupdater.FileData;
import fr.aventuros.mclauncherlib.utils.FileDownloader;
import fr.aventuros.mclauncherlib.utils.files.FileUtils;
import fr.aventuros.mclauncherlib.utils.pair.ImmutablePair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LauncherFilesUpdater {
    private final File destination;
    private final String destinationPath;
    private final String[] ignoreFiles;
    private final DownloadSource[] downloadSources;
    private boolean started = false;
    private final Map<String, FileData> finalFilesDownloadLocations = new HashMap<String, FileData>();
    private final int dlThreadCount;
    private long totalSizeToDownload = -1L;
    private final AtomicLong sizeDownloaded = new AtomicLong(0L);
    private int totalFilesToDownload = -1;
    private final AtomicInteger filesDownloaded = new AtomicInteger(0);
    private DownloadStatus status = DownloadStatus.PREPARING;
    private static final MessageDigest sha256;

    @Deprecated
    public LauncherFilesUpdater(File destination, List<String> ignoreFiles, int dlThreadCount, DownloadSource ... downloadSources) throws IOException {
        this(destination, ignoreFiles.toArray(new String[0]), dlThreadCount, downloadSources);
    }

    public LauncherFilesUpdater(File destination, String[] ignoreFiles, int dlThreadCount, DownloadSource ... downloadSources) throws IOException {
        this.destination = destination.getCanonicalFile();
        this.destinationPath = this.destination.getAbsolutePath();
        this.ignoreFiles = ignoreFiles;
        this.dlThreadCount = dlThreadCount;
        this.downloadSources = downloadSources;
    }

    private ImmutablePair<File[], File[]> doPhaseCheck() throws IOException, InterruptedException {
        this.status = DownloadStatus.CHECKING;
        AtomicInteger totalFilesToDownload = new AtomicInteger(this.finalFilesDownloadLocations.size());
        AtomicLong totalSizeToDownload = new AtomicLong(this.finalFilesDownloadLocations.values().stream().mapToLong(FileData::getSize).sum());
        ArrayList toDelete = new ArrayList();
        ArrayList toDeleteIfEmpty = new ArrayList();
        FileUtils.listDir(this.destination, file -> {
            this.checkInterrupted();
            String filePath = this.getShortenedName((File)file);
            FileData fileData = this.finalFilesDownloadLocations.get(filePath);
            if (fileData == null) {
                if (this.isFileChecked(filePath)) {
                    toDelete.add(file);
                }
            } else if (file.length() == fileData.getSize() && LauncherFilesUpdater.calculateFileChecksum(file).equals(fileData.getHash())) {
                this.finalFilesDownloadLocations.remove(filePath);
                totalFilesToDownload.getAndDecrement();
                totalSizeToDownload.addAndGet(-fileData.getSize());
            }
        }, file -> {
            if (this.isFileChecked(this.getShortenedName((File)file))) {
                toDeleteIfEmpty.add(file);
            }
        });
        this.totalFilesToDownload = totalFilesToDownload.get();
        this.totalSizeToDownload = totalSizeToDownload.get();
        return new ImmutablePair<File[], File[]>(toDelete.toArray(new File[0]), toDeleteIfEmpty.toArray(new File[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPhaseDownload() throws IOException, InterruptedException {
        this.status = DownloadStatus.DOWNLOADING;
        ArrayList<Future<Object>> downloadFutures = new ArrayList<Future<Object>>();
        ExecutorService executor = Executors.newFixedThreadPool(this.dlThreadCount);
        try {
            for (Map.Entry<String, FileData> fileDataEntry : this.finalFilesDownloadLocations.entrySet()) {
                downloadFutures.add(executor.submit(() -> {
                    String filePath = (String)fileDataEntry.getKey();
                    File file = new File(this.destination, filePath);
                    File parent = file.getParentFile();
                    if (!parent.mkdirs() && !parent.exists()) {
                        throw new IOException("Impossible de cr\u00e9er le dossier " + parent.getAbsolutePath());
                    }
                    new FileDownloader(((FileData)fileDataEntry.getValue()).getDownloadLocation()).downloadToFile(file, this.sizeDownloaded::addAndGet);
                    this.filesDownloaded.addAndGet(1);
                    return null;
                }));
            }
            boolean cancel = false;
            for (Future future : downloadFutures) {
                if (cancel) {
                    future.cancel(true);
                    continue;
                }
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    cancel = true;
                    executor.shutdownNow();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
            if (cancel) {
                throw new InterruptedException();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void doPhaseDelete(File[] toDelete, File[] toDeleteIfEmpty) throws InterruptedException, IOException {
        this.status = DownloadStatus.DELETING;
        for (File file : toDelete) {
            this.checkInterrupted();
            if (!file.delete()) {
                throw new IOException("Impossible de supprimer " + file.getAbsolutePath());
            }
            this.recursiveDeleteEmptyDirs(file.getParentFile());
        }
        for (File file : toDeleteIfEmpty) {
            this.checkInterrupted();
            this.recursiveDeleteEmptyDirs(file);
        }
    }

    private void recursiveDeleteEmptyDirs(File file) {
        String[] list;
        if (!file.isDirectory()) {
            return;
        }
        while (this.isInDestination(file) && (list = file.list()) != null && list.length <= 0) {
            if (!file.delete()) {
                return;
            }
            file = file.getParentFile();
        }
    }

    private boolean isInDestination(File file) {
        String filePath = file.getAbsolutePath();
        return filePath.startsWith(this.destinationPath) && filePath.length() > this.destinationPath.length();
    }

    private String getShortenedName(File file) {
        if (this.isInDestination(file)) {
            String shortenedName = file.getAbsolutePath().substring(this.destination.getAbsolutePath().length() + 1);
            if (File.separatorChar == '/') {
                return shortenedName;
            }
            return shortenedName.replace(File.separator, "/");
        }
        return file.getAbsolutePath();
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private HashMap<String, FileData> getFilesData(String indexLocation, String filesDownloadDir) throws IOException {
        if (filesDownloadDir.endsWith("/")) {
            filesDownloadDir = filesDownloadDir.substring(0, filesDownloadDir.length() - 1);
        }
        HashMap<String, FileData> fileHashes = new HashMap<String, FileData>();
        for (Map.Entry<String, JsonElement> e : JsonParser.parseReader(new FileDownloader(indexLocation).downloadReader()).getAsJsonObject().entrySet()) {
            String filePath = e.getKey();
            JsonObject fileData = e.getValue().getAsJsonObject();
            StringBuilder encodedPath = new StringBuilder();
            for (String pathPiece : filePath.split("/")) {
                encodedPath.append("/").append(URLEncoder.encode(pathPiece, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20"));
            }
            fileHashes.put(filePath, new FileData(fileData.get("hash").getAsString(), fileData.get("size").getAsLong(), filesDownloadDir + encodedPath));
        }
        return fileHashes;
    }

    private static String calculateFileChecksum(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                sha256.update(buffer, 0, length);
            }
        }
        byte[] hash = sha256.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : hash) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private boolean isFileChecked(String file) {
        for (String ignoredFile : this.ignoreFiles) {
            if (!file.startsWith(ignoredFile)) continue;
            return false;
        }
        return true;
    }

    public void start() throws IOException, InterruptedException {
        if (this.started) {
            throw new IllegalStateException("Updaters can only be started once");
        }
        this.started = true;
        for (DownloadSource downloadSource : this.downloadSources) {
            this.finalFilesDownloadLocations.putAll(this.getFilesData(downloadSource.getIndexLocation(), downloadSource.getFilesDownloadDir()));
        }
        ImmutablePair<File[], File[]> ret = this.doPhaseCheck();
        File[] toDelete = (File[])ret.a;
        File[] toDeleteIfEmpty = (File[])ret.b;
        this.doPhaseDownload();
        this.doPhaseDelete(toDelete, toDeleteIfEmpty);
        this.status = DownloadStatus.COMPLETED;
    }

    public long getTotalSizeToDownload() {
        return this.totalSizeToDownload;
    }

    public long getSizeDownloaded() {
        return this.sizeDownloaded.get();
    }

    public long getTotalFilesToDownload() {
        return this.totalFilesToDownload;
    }

    public long getFilesDownloaded() {
        return this.filesDownloaded.get();
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public File getDestination() {
        return this.destination;
    }

    static {
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

