/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.mclauncherlib;

import com.sun.istack.internal.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;

public class UniqueInstanceChecker {
    private static final byte[] wakeUpPacket = new byte[]{93, -1, 114, -127, -17, 49, -53, 112, 120, 97, 54, -34, 29, -82, -125, 28};
    private final int port;
    private final Runnable onSecondInstanceStart;

    public UniqueInstanceChecker(int port) {
        this(port, null);
    }

    public UniqueInstanceChecker(int port, @Nullable Runnable onSecondInstanceStart) {
        this.port = port;
        this.onSecondInstanceStart = onSecondInstanceStart;
    }

    public boolean checkSingleInstance() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port, 5, InetAddress.getLoopbackAddress());
            Thread t = this.createServerWaitingThread(serverSocket);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                t.interrupt();
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            return true;
        }
        catch (IOException e) {
            if (this.onSecondInstanceStart != null) {
                try (Socket socket = new Socket(InetAddress.getLoopbackAddress(), this.port);){
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(wakeUpPacket);
                    outputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
    }

    private Thread createServerWaitingThread(ServerSocket serverSocket) {
        Thread t = new Thread(() -> {
            while (!serverSocket.isClosed()) {
                try {
                    Socket socket = serverSocket.accept();
                    socket.setSoTimeout(3000);
                    byte[] read = new byte[wakeUpPacket.length];
                    InputStream inputStream = socket.getInputStream();
                    inputStream.read(read);
                    inputStream.close();
                    socket.close();
                    if (this.onSecondInstanceStart == null) continue;
                    if (Arrays.equals(wakeUpPacket, read)) {
                        try {
                            this.onSecondInstanceStart.run();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    System.out.println("Invalid packet received on instance duplicate checking port. Is another program using it ?");
                }
                catch (IOException iOException) {}
            }
        });
        t.start();
        return t;
    }
}

