/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.utils.http;

import fr.aventuros.launcher.utils.http.Readable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class MultipartFormdataBuilder {
    private final OutputStream outputStream;
    private final byte[] boundaryBytes;
    private final byte[] finishBoundaryBytes;

    public MultipartFormdataBuilder(HttpURLConnection connection) throws IOException {
        connection.setRequestMethod("POST");
        String boundary = UUID.randomUUID().toString();
        this.boundaryBytes = ("--" + boundary + "\r\n").getBytes(StandardCharsets.UTF_8);
        this.finishBoundaryBytes = ("--" + boundary + "--").getBytes(StandardCharsets.UTF_8);
        connection.setRequestProperty("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
        connection.setChunkedStreamingMode(0);
        connection.setDoOutput(true);
        this.outputStream = connection.getOutputStream();
    }

    public void sendBoundaryBytes() throws IOException {
        this.outputStream.write(this.boundaryBytes);
    }

    public void sendFile(String name, Readable in, String fileName) throws IOException {
        this.sendBoundaryBytes();
        String o = String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n\r\n", URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(fileName, "UTF-8"));
        this.outputStream.write(o.getBytes(StandardCharsets.UTF_8));
        byte[] buffer = new byte[2048];
        int n = 0;
        while (n >= 0) {
            this.outputStream.write(buffer, 0, n);
            n = in.read(buffer);
        }
        this.outputStream.write("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    public void sendFile(String name, InputStream in, String filename) throws IOException {
        this.sendFile(name, in::read, filename);
    }

    public void sendFile(String name, RandomAccessFile in, String filename) throws IOException {
        this.sendFile(name, in::read, filename);
    }

    public void sendField(String name, byte[] data) throws IOException {
        this.sendBoundaryBytes();
        String o = String.format("Content-Disposition: form-data; name=\"%s\"\r\n\r\n", URLEncoder.encode(name, "UTF-8"));
        this.outputStream.write(o.getBytes(StandardCharsets.UTF_8));
        this.outputStream.write(data);
        this.outputStream.write("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    public void sendField(String name, String data) throws IOException {
        this.sendField(name, data.getBytes(StandardCharsets.UTF_8));
    }

    public void finish() throws IOException {
        this.outputStream.write(this.finishBoundaryBytes);
        this.outputStream.close();
    }
}

