/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.utils.http;

import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.data.MicrosoftAuthResult;
import fr.aventuros.mclauncherlib.Authentification;
import fr.litarvan.openauth.microsoft.AuthTokens;
import fr.litarvan.openauth.microsoft.HttpClient;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticationException;
import fr.litarvan.openauth.microsoft.model.response.MicrosoftRefreshResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MicrosoftAuthHelper {
    private static final Map<String, String> loginParams;
    private static final HttpClient http;

    private MicrosoftAuthHelper() {
        throw new AssertionError();
    }

    public static MicrosoftAuthResult loginWithRefreshToken(String refreshToken) throws MicrosoftAuthenticationException {
        HashMap<String, String> params = new HashMap<String, String>(loginParams);
        params.put("refresh_token", refreshToken);
        params.put("grant_type", "refresh_token");
        MicrosoftRefreshResponse response = http.postFormGetJson("https://login.live.com/oauth20_token.srf", params, MicrosoftRefreshResponse.class);
        return new MicrosoftAuthResult(Authentification.microsoftAuthTokens(new AuthTokens(response.getAccessToken(), response.getRefreshToken())), Utils.currentTimeSec() + response.getExpiresIn());
    }

    static {
        http = new HttpClient();
        HashMap<String, String> loginParamsBuilder = new HashMap<String, String>();
        loginParamsBuilder.put("client_id", "000000004C12AE6F");
        loginParamsBuilder.put("redirect_uri", "https://login.live.com/oauth20_desktop.srf");
        loginParamsBuilder.put("scope", "service::user.auth.xboxlive.com::MBI_SSL");
        loginParamsBuilder.put("response_type", "token");
        loginParams = Collections.unmodifiableMap(loginParamsBuilder);
    }
}

