/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.utils.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class GsonUtils {
    public static final ExclusionStrategy unexposeExclusion = new ExclusionStrategy(){

        @Override
        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Unexpose.class) != null;
        }

        @Override
        public boolean shouldSkipClass(Class<?> aClass) {
            return ((Unexpose[])aClass.getAnnotationsByType(Unexpose.class)).length > 0;
        }
    };

    private GsonUtils() {
        throw new AssertionError();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Unexpose {
    }
}

