/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.utils;

import fr.theshark34.swinger.Swinger;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Utils {
    public static final Logger LOGGER = Logger.getLogger("Launcher");
    private static final String assetsPath = "/assets/aventuros/launcher";
    private static final BufferedImage errorImage = new BufferedImage(2, 2, 1);

    private Utils() {
        throw new AssertionError();
    }

    public static BufferedImage getImageResource(String resource) {
        try {
            return Swinger.getResource(resource);
        }
        catch (Throwable e) {
            System.err.printf("Failed to load resource %s%n", resource);
            e.printStackTrace();
            return errorImage;
        }
    }

    public static URL getRessource(String ressource) {
        return Utils.class.getResource("/assets/aventuros/launcher/" + ressource);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static long currentTimeSec() {
        return System.currentTimeMillis() / 1000L;
    }

    static {
        Swinger.setResourcePath("/assets/aventuros/launcher/images");
        LOGGER.setLevel(Level.INFO);
        errorImage.setRGB(0, 0, -9107549);
        errorImage.setRGB(0, 1, -16777216);
        errorImage.setRGB(1, 0, -16777216);
        errorImage.setRGB(1, 1, -9107549);
    }
}

