/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;

public final class PremiumTest {
    private static final HashMap<String, PremiumTest> cache = new HashMap();
    public final String errorMessage;
    public final UUID uuid;

    private PremiumTest() {
        this.errorMessage = null;
        this.uuid = null;
    }

    private PremiumTest(String errorMessage) {
        this.errorMessage = errorMessage;
        this.uuid = null;
    }

    public PremiumTest(UUID uuid) {
        this.errorMessage = null;
        this.uuid = uuid;
    }

    public static PremiumTest get(String username) {
        PremiumTest value = cache.get(username);
        if (value == null) {
            value = PremiumTest.fetch(username);
            cache.put(username, value);
        }
        return value;
    }

    private static PremiumTest fetch(String username) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.mojang.com/users/profiles/minecraft/" + URLEncoder.encode(username, StandardCharsets.UTF_8.toString())).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Aventuros Launcher Premium Account Checker");
            int responseCode = connection.getResponseCode();
            if (responseCode == 204 || responseCode == 404) {
                return new PremiumTest();
            }
            JsonElement elementResponse = JsonParser.parseReader(new InputStreamReader(connection.getInputStream()));
            if (elementResponse.isJsonObject()) {
                JsonObject response = elementResponse.getAsJsonObject();
                if (responseCode == 200 && response.has("name") && response.has("id") && response.get("name").getAsString().equalsIgnoreCase(username)) {
                    UUID uuid = UUID.fromString(response.get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
                    return new PremiumTest(uuid);
                }
                if (response.has("errorMessage")) {
                    return new PremiumTest(response.get("errorMessage").getAsString());
                }
            } else {
                System.err.printf("What ? Not json object: Code: %s\nJSON: %s%n", responseCode, elementResponse);
            }
            return new PremiumTest("Une erreur inconnue est survenue durant la v\u00e9rification de votre compte.");
        }
        catch (FileNotFoundException e) {
            return new PremiumTest();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new PremiumTest(e.toString());
        }
    }
}

