/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.utils;

import fr.theshark34.swinger.Swinger;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class GraphicsUtils {
    private GraphicsUtils() {
        throw new AssertionError();
    }

    public static BufferedImage fillImageByTransparency(BufferedImage image, Color color) {
        BufferedImage image2 = GraphicsUtils.copyImage(image);
        Swinger.fillImage(image2, color, null);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if ((image.getRGB(x, y) & 0xFF000000) != 0) continue;
                image2.setRGB(x, y, 0);
            }
        }
        return image2;
    }

    public static BufferedImage copyImage(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        Graphics g = b.getGraphics();
        g.drawImage(source, 0, 0, null);
        g.dispose();
        return b;
    }

    public static void fillRoundRect(Graphics g, int x, int y, int width, int height, int arcSize, Color color) {
        Swinger.activateAntialias(g);
        g.setColor(color);
        g.fillRoundRect(x, y, width, height, arcSize, arcSize);
    }

    public static void fillRect(Graphics g, int x, int y, int width, int height, Color color) {
        g.setColor(color);
        g.fillRect(x, y, width, height);
    }

    public static BufferedImage getRoundedCornerRectangle(int width, int height, int arcSize, Color color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        GraphicsUtils.fillRoundRect(image.getGraphics(), 0, 0, width, height, arcSize, color);
        return image;
    }

    public static BufferedImage getRectangle(int width, int height, Color color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        GraphicsUtils.fillRect(image.getGraphics(), 0, 0, width, height, color);
        return image;
    }

    public static void drawCenteredString(Graphics g, String str, Rectangle parent) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(str, g);
        double x = (parent.getWidth() - stringBounds.getWidth()) / 2.0;
        double y = (parent.getHeight() - stringBounds.getHeight()) / 2.0 + (double)fm.getAscent();
        Point centerPos = new Point((int)x, (int)y);
        g.drawString(str, (int)centerPos.getX(), (int)centerPos.getY());
    }

    public static BufferedImage blendImages(BufferedImage image1, BufferedImage image2, float fadeProgress) {
        int width = image1.getWidth();
        int height = image1.getHeight();
        BufferedImage fadedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb1 = image1.getRGB(x, y);
                int argb2 = image2.getRGB(x, y);
                int a1 = argb1 >> 24 & 0xFF;
                int r1 = argb1 >> 16 & 0xFF;
                int g1 = argb1 >> 8 & 0xFF;
                int b1 = argb1 & 0xFF;
                int a2 = argb2 >> 24 & 0xFF;
                int r2 = argb2 >> 16 & 0xFF;
                int g2 = argb2 >> 8 & 0xFF;
                int b2 = argb2 & 0xFF;
                int a = Math.round((1.0f - fadeProgress) * (float)a1 + fadeProgress * (float)a2);
                int r = Math.round((1.0f - fadeProgress) * (float)r1 + fadeProgress * (float)r2);
                int g = Math.round((1.0f - fadeProgress) * (float)g1 + fadeProgress * (float)g2);
                int b = Math.round((1.0f - fadeProgress) * (float)b1 + fadeProgress * (float)b2);
                fadedImage.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return fadedImage;
    }
}

