/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.sun.istack.internal.Nullable;
import fr.aventuros.launcher.Launcher;
import fr.aventuros.launcher.settings.AdditionalMods;
import fr.aventuros.launcher.settings.GameSettings;
import fr.aventuros.launcher.settings.SavedAccount;
import fr.aventuros.launcher.settings.SavedAccountsList;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.data.MicrosoftAuthResult;
import fr.aventuros.launcher.utils.gson.FileSerializer;
import fr.aventuros.launcher.utils.gson.GsonUtils;
import fr.aventuros.mclauncherlib.Authentification;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Properties;

public final class Settings {
    private static final Gson settingsGson = new GsonBuilder().registerTypeAdapter((Type)((Object)SavedAccount.class), new SavedAccount.Deserializer()).registerTypeAdapter((Type)((Object)SavedAccount.CrackedSavedAccount.class), new SavedAccount.CrackedSavedAccount.Serializer()).registerTypeAdapter((Type)((Object)SavedAccount.MicrosoftSavedAccount.class), new SavedAccount.MicrosoftSavedAccount.Serializer()).registerTypeAdapter((Type)((Object)File.class), FileSerializer.INSTANCE).addSerializationExclusionStrategy(GsonUtils.unexposeExclusion).create();
    private static final File settingsFile = new File(Launcher.launcherDir, "settings.json");
    public static final Settings settings = Settings.loadSettings();
    public final GameSettings gameSettings = new GameSettings();
    private File gameDir;
    public final SavedAccountsList connectedAccounts = new SavedAccountsList();
    public final AdditionalMods additionalMods = new AdditionalMods();
    public boolean autoStartGame = false;
    @GsonUtils.Unexpose
    @Deprecated
    public SavedAccount connectedAccount;

    private Settings() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Settings loadSettings() {
        if (!settingsFile.exists()) return new Settings();
        try (FileReader fileReader = new FileReader(settingsFile);){
            Settings settings = settingsGson.fromJson((Reader)fileReader, Settings.class);
            return settings;
        }
        catch (JsonSyntaxException | IOException e) {
            Launcher.errorCatcher.catchError(e, "Impossible de charger le fichier des param\u00e8tres, les param\u00e8tres vont \u00eatre r\u00e9initialis\u00e9s.");
        }
        return new Settings();
    }

    private static void convertRamTXT() {
        File ramFile = new File(Launcher.defaultGameDir, "ram.txt");
        if (ramFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(ramFile));){
                String ramText = br.readLine();
                if (ramText != null) {
                    Settings.settings.gameSettings.ram = Integer.parseInt(ramText);
                }
            }
            catch (IOException e) {
                Utils.LOGGER.warning("Cannot read ram.txt file");
                e.printStackTrace();
            }
            catch (NumberFormatException e) {
                Utils.LOGGER.warning("Cannot parse ram.txt file");
                e.printStackTrace();
            }
            ramFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertLauncherProperties() {
        block15: {
            File saverFile = new File(Launcher.defaultGameDir, "launcher.properties");
            if (!saverFile.exists()) break block15;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(saverFile);
                properties.load(fileInputStream);
            }
            catch (IOException e) {
                try {
                    Utils.LOGGER.warning("Cannot read launcher.properties");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(fileInputStream);
                    throw throwable;
                }
                Utils.closeQuietly(fileInputStream);
                return;
            }
            Utils.closeQuietly(fileInputStream);
            String gameDirPath = properties.getProperty("game_dir");
            if (gameDirPath != null) {
                Settings.settings.gameDir = new File(gameDirPath);
            }
            Settings.settings.gameSettings.ram = Integer.parseInt(properties.getProperty("ram", String.valueOf(Settings.settings.gameSettings.ram)));
            switch (properties.getProperty("account", "")) {
                case "microsoft": {
                    try {
                        Settings.settings.connectedAccounts.addAccount(new SavedAccount.MicrosoftSavedAccount(new MicrosoftAuthResult(Authentification.microsoftAuth(properties.getProperty("username"), new String(Base64.getDecoder().decode(properties.getProperty("password")))), Utils.currentTimeSec() + 86400L)));
                    }
                    catch (MicrosoftAuthenticationException | IOException e) {
                        Utils.LOGGER.warning("Error occurred while updating account settings");
                        e.printStackTrace();
                    }
                    break;
                }
                case "cracked": {
                    Settings.settings.connectedAccounts.addAccount(new SavedAccount.CrackedSavedAccount(properties.getProperty("username")));
                }
            }
            saverFile.delete();
        }
    }

    private static void convertOldSettingsJSON() {
        if (Settings.settings.connectedAccount != null) {
            Settings.settings.connectedAccounts.addAccount(Settings.settings.connectedAccount);
            Settings.settings.connectedAccount = null;
        }
    }

    public void setGameDir(@Nullable File gameDir) {
        this.gameDir = gameDir;
        this.save();
    }

    @Nullable
    public File getSettingGameDir() {
        return this.gameDir;
    }

    public File getFinalGameDir() {
        if (this.gameDir == null) {
            return Launcher.defaultGameDir;
        }
        return this.gameDir;
    }

    public void save() {
        try {
            settingsFile.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(settingsFile);
            fileWriter.write(settingsGson.toJson(this));
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Settings.convertRamTXT();
        Settings.convertLauncherProperties();
        Settings.convertOldSettingsJSON();
        Settings.settings.connectedAccounts.checkSavedAccounts();
        settings.save();
    }
}

