/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.settings;

import fr.aventuros.launcher.settings.SavedAccount;
import fr.aventuros.launcher.utils.Utils;
import java.util.ArrayList;
import java.util.function.BiConsumer;

public class SavedAccountsList {
    public int selectedIndex;
    private final ArrayList<SavedAccount> accounts = new ArrayList();

    public boolean hasNoAccounts() {
        return this.accounts.isEmpty();
    }

    public SavedAccount getSelectedAccount() {
        try {
            return this.accounts.get(this.selectedIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public SavedAccount removeAccount(int index) {
        SavedAccount removedAccount = this.accounts.remove(index);
        if (this.selectedIndex == index) {
            this.selectedIndex = 0;
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
        return removedAccount;
    }

    public void addAccount(SavedAccount addAccount) {
        ArrayList<SavedAccount> savedAccounts = this.accounts;
        for (int i = 0; i < savedAccounts.size(); ++i) {
            SavedAccount other = savedAccounts.get(i);
            if (!other.username.equalsIgnoreCase(addAccount.username)) continue;
            if (addAccount instanceof SavedAccount.MicrosoftSavedAccount || other instanceof SavedAccount.CrackedSavedAccount) {
                savedAccounts.remove(i);
                savedAccounts.add(i, addAccount);
                this.selectedIndex = i;
                return;
            }
            return;
        }
        this.selectedIndex = this.accounts.size();
        savedAccounts.add(addAccount);
    }

    public void foreachAccount(BiConsumer<Integer, SavedAccount> consumer) {
        int size = this.accounts.size();
        for (int i = 0; i < size; ++i) {
            consumer.accept(i, this.accounts.get(i));
        }
    }

    public int getAccountsCount() {
        return this.accounts.size();
    }

    public void checkSavedAccounts() {
        for (int i = this.accounts.size() - 1; i >= 0; --i) {
            SavedAccount savedAccount = this.accounts.get(i);
            if (savedAccount instanceof SavedAccount.CrackedSavedAccount) {
                if (!SavedAccount.CrackedSavedAccount.isUsernameInvalid(savedAccount.username)) continue;
                this.removeAccount(i);
                continue;
            }
            SavedAccount.MicrosoftSavedAccount microsoftSavedAccount = (SavedAccount.MicrosoftSavedAccount)savedAccount;
            try {
                microsoftSavedAccount.getUUID();
                continue;
            }
            catch (RuntimeException e) {
                Utils.LOGGER.warning(String.format("Could not reconnect account %s", microsoftSavedAccount.username));
                e.getCause().printStackTrace();
                this.removeAccount(i);
            }
        }
    }
}

