/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.settings;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.data.MicrosoftAuthResult;
import fr.aventuros.launcher.utils.http.MicrosoftAuthHelper;
import fr.litarvan.openauth.microsoft.model.response.MinecraftProfile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public abstract class SavedAccount {
    private static final BufferedImage steveHead = Utils.getImageResource("steve_head.png");
    public final String username;

    public SavedAccount(String username) {
        this.username = username;
    }

    public abstract BufferedImage getHeadImage();

    public abstract String getAccountTypeString();

    public abstract String getAccessToken();

    public abstract String getUUID();

    public static class CrackedSavedAccount
    extends SavedAccount {
        private static final Pattern validUsernamePattern = Pattern.compile("^\\w{3,16}$");

        public CrackedSavedAccount(String username) {
            super(username);
        }

        public static boolean isUsernameInvalid(String username) {
            return !validUsernamePattern.matcher(username).matches();
        }

        @Override
        public BufferedImage getHeadImage() {
            return steveHead;
        }

        @Override
        public String getAccountTypeString() {
            return "Compte Crack";
        }

        @Override
        public String getAccessToken() {
            return null;
        }

        @Override
        public String getUUID() {
            return null;
        }

        static class Serializer
        implements JsonSerializer<CrackedSavedAccount> {
            Serializer() {
            }

            @Override
            public JsonElement serialize(CrackedSavedAccount crackedSavedAccount, Type type, JsonSerializationContext jsonSerializationContext) {
                JsonObject object = new JsonObject();
                object.addProperty("accountType", 0);
                object.addProperty("username", crackedSavedAccount.username);
                return object;
            }
        }
    }

    public static class MicrosoftSavedAccount
    extends SavedAccount {
        private final CompletableFuture<MicrosoftAuthInfos> authInfos = new CompletableFuture();

        public MicrosoftSavedAccount(MicrosoftAuthResult tokens) throws IOException {
            super(tokens.profile.getName());
            new Thread(() -> {
                try {
                    this.completeFromTokens(tokens);
                }
                catch (Throwable e) {
                    this.authInfos.completeExceptionally(e);
                }
            }).start();
        }

        public MicrosoftSavedAccount(String username, String refreshToken, String accessToken, String uuid, long expiresAt, String skinURL) {
            super(username);
            new Thread(() -> {
                try {
                    if (Utils.currentTimeSec() > expiresAt - 21600L) {
                        this.completeFromTokens(MicrosoftAuthHelper.loginWithRefreshToken(refreshToken));
                    } else {
                        this.completeWithSkinURL(refreshToken, accessToken, uuid, expiresAt, skinURL);
                    }
                }
                catch (Throwable e) {
                    this.authInfos.completeExceptionally(e);
                }
            }).start();
        }

        private void completeWithSkinURL(String refreshToken, String accessToken, String uuid, long expiresAt, String skinURL) {
            BufferedImage headImageCache;
            if (skinURL == null) {
                headImageCache = steveHead;
            } else {
                try {
                    BufferedImage skinImage = ImageIO.read(new URL(skinURL));
                    headImageCache = skinImage.getSubimage(8, 8, 8, 8);
                    headImageCache.getGraphics().drawImage(skinImage.getSubimage(40, 8, 8, 8), 0, 0, 8, 8, null);
                }
                catch (Throwable e) {
                    Utils.LOGGER.warning(String.format("Could not load skin for %s account", this.username));
                    e.printStackTrace();
                    headImageCache = steveHead;
                }
            }
            this.authInfos.complete(new MicrosoftAuthInfos(refreshToken, accessToken, uuid, expiresAt, skinURL, headImageCache));
        }

        private void completeFromTokens(MicrosoftAuthResult tokens) {
            String skinURL;
            block1: {
                for (MinecraftProfile.MinecraftSkin skin : tokens.profile.getSkins()) {
                    if (!skin.getState().equals("ACTIVE")) continue;
                    skinURL = skin.getUrl();
                    break block1;
                }
                skinURL = null;
            }
            this.completeWithSkinURL(tokens.refreshToken, tokens.accessToken, tokens.profile.getId(), tokens.expireAt, skinURL);
        }

        private MicrosoftAuthInfos getAuthInfos() {
            try {
                return this.authInfos.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getAccessToken() {
            return this.getAuthInfos().accessToken;
        }

        @Override
        public String getUUID() {
            return this.getAuthInfos().uuid;
        }

        @Override
        public BufferedImage getHeadImage() {
            return this.getAuthInfos().headImageCache;
        }

        @Override
        public String getAccountTypeString() {
            return "Compte Microsoft";
        }

        static class Serializer
        implements JsonSerializer<MicrosoftSavedAccount> {
            Serializer() {
            }

            @Override
            public JsonElement serialize(MicrosoftSavedAccount microsoftSavedAccount, Type type, JsonSerializationContext jsonSerializationContext) {
                JsonObject object = new JsonObject();
                object.addProperty("accountType", 1);
                object.addProperty("username", microsoftSavedAccount.username);
                MicrosoftAuthInfos authInfos = microsoftSavedAccount.getAuthInfos();
                object.addProperty("refreshToken", authInfos.refreshToken);
                object.addProperty("accessToken", authInfos.accessToken);
                object.addProperty("uuid", authInfos.uuid);
                object.addProperty("expiresAt", authInfos.expiresAt);
                object.addProperty("skinURL", authInfos.skinURL);
                return object;
            }
        }
    }

    private static class MicrosoftAuthInfos {
        public final String refreshToken;
        public final String accessToken;
        public final String uuid;
        public final long expiresAt;
        public final String skinURL;
        public final BufferedImage headImageCache;

        public MicrosoftAuthInfos(String refreshToken, String accessToken, String uuid, long expiresAt, String skinURL, BufferedImage headImageCache) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.uuid = uuid;
            this.expiresAt = expiresAt;
            this.skinURL = skinURL;
            this.headImageCache = headImageCache;
        }
    }

    static class Deserializer
    implements JsonDeserializer<SavedAccount> {
        Deserializer() {
        }

        @Override
        public SavedAccount deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                int typeInt;
                if (!jsonElement.isJsonObject()) {
                    return null;
                }
                JsonObject object = jsonElement.getAsJsonObject();
                JsonPrimitive typeElement = object.get("accountType").getAsJsonPrimitive();
                if (typeElement.isString()) {
                    typeInt = typeElement.getAsString().equals("MICROSOFT") ? 1 : 0;
                } else if (typeElement.isNumber()) {
                    typeInt = typeElement.getAsInt();
                } else {
                    return null;
                }
                JsonElement usernameElement = object.get("username");
                switch (typeInt) {
                    case 0: {
                        return new CrackedSavedAccount(usernameElement.getAsString());
                    }
                    case 1: {
                        String refreshToken = object.get("refreshToken").getAsString();
                        if (usernameElement == null) {
                            Utils.LOGGER.warning("Sync refreshing microsoft account as no username was specified in settings");
                            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                                System.out.println(element);
                            }
                            MicrosoftAuthResult authResult = MicrosoftAuthHelper.loginWithRefreshToken(refreshToken);
                            return new MicrosoftSavedAccount(authResult);
                        }
                        String accessToken = object.get("accessToken").getAsString();
                        String uuid = object.get("uuid").getAsString();
                        long expiresAt = object.get("expiresAt").getAsLong();
                        String skinURL = object.get("skinURL").getAsString();
                        return new MicrosoftSavedAccount(usernameElement.getAsString(), refreshToken, accessToken, uuid, expiresAt, skinURL);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

