/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.panels;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.components.CImage;
import fr.aventuros.launcher.gui.components.CRoundedRectangle;
import fr.aventuros.launcher.gui.components.CWaitingProgressBar;
import fr.aventuros.launcher.gui.panels.AbstractLauncherPanel;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.Utils;
import fr.theshark34.swinger.Swinger;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class SplashPanel
extends AbstractLauncherPanel {
    private static final Color debugInfosBackgroundColor = new Color(40, 40, 40);
    private static final int imageWidth = 648;
    private static final int imageHeight = 98;
    private static final BufferedImage splashImage = Utils.getImageResource("splash.png");

    public SplashPanel(LauncherFrame launcherFrame) {
        super(launcherFrame);
        int midX = 545;
        int imgX = midX - 324;
        int imgY = 215;
        Rectangle barRect = new Rectangle(imgX, imgY + 98 + 20, 648, 20);
        JLabel loadingLabel = new JLabel("Chargement du launcher...", 0);
        loadingLabel.setBounds(barRect);
        loadingLabel.setFont(new Font("Comfortaa", 0, 15));
        loadingLabel.setBackground(Swinger.TRANSPARENT);
        loadingLabel.setForeground(Color.WHITE);
        this.add(loadingLabel);
        CWaitingProgressBar waitingBar = new CWaitingProgressBar(Constants.barBackground, Constants.barForeground, 80, 5);
        waitingBar.setBounds(barRect);
        this.add(waitingBar);
        CImage textBackground = new CImage(splashImage);
        textBackground.setBounds(imgX, imgY, 648, 98);
        this.add(textBackground);
        CRoundedRectangle componentsBackground = new CRoundedRectangle(Constants.lightDarkBackgroundColor, 10);
        componentsBackground.setBounds(imgX - 20, imgY - 20, 688, 178);
        this.add(componentsBackground);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (e.getKeyCode() == 114) {
            this.showDebugInfo();
        }
    }

    private void showDebugInfo() {
        StringBuilder builder = new StringBuilder();
        Properties properties = System.getProperties();
        if (!properties.isEmpty()) {
            builder.append("\t[PROPERTIES]");
            for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
                builder.append("\n").append(propertyEntry.getKey()).append(": ").append(propertyEntry.getValue());
            }
        }
        String debugInfos = builder.toString();
        JFrame frame = new JFrame("Aventuros Launcher - Informations de d\u00e9bogage");
        frame.setIconImage(LauncherFrame.iconImage);
        frame.setDefaultCloseOperation(2);
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        frame.setSize((int)((double)screenBounds.width / 1.5), (int)((double)screenBounds.height / 1.5));
        frame.setLocationRelativeTo(null);
        frame.setExtendedState(6);
        frame.setBackground(debugInfosBackgroundColor);
        JTextArea textArea = new JTextArea(debugInfos);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setWrapStyleWord(false);
        textArea.setCursor(Cursor.getPredefinedCursor(2));
        textArea.setBackground(debugInfosBackgroundColor);
        textArea.setForeground(Color.WHITE);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
        scrollPane.setBackground(debugInfosBackgroundColor);
        frame.add(scrollPane);
        frame.setVisible(true);
        System.out.println(debugInfos);
    }
}

