/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.panels;

import fr.aventuros.launcher.Launcher;
import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.OptionFrame;
import fr.aventuros.launcher.gui.components.CImage;
import fr.aventuros.launcher.gui.components.buttons.AbstractButton;
import fr.aventuros.launcher.gui.components.buttons.CTextRoundedBackgroundButton;
import fr.aventuros.launcher.gui.components.buttons.CTransitionTexturedButton;
import fr.aventuros.launcher.gui.panels.AbstractLauncherPanel;
import fr.aventuros.launcher.settings.SavedAccount;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.GraphicsUtils;
import fr.aventuros.launcher.utils.Utils;
import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.colored.SColoredBar;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class MainLauncherPanel
extends AbstractLauncherPanel {
    private final CImage accountImage = new CImage();
    private final JLabel accountName = new JLabel();
    private final JLabel accountType = new JLabel();
    private final CTransitionTexturedButton changeAccountButton = new CTransitionTexturedButton(GraphicsUtils.getRoundedCornerRectangle(275, 110, 10, Constants.buttonBackgroundColor), this::changeAccountBtnClick);
    private final CTextRoundedBackgroundButton connectBtn = new CTextRoundedBackgroundButton(200, 45, 10, Constants.buttonBackgroundColor, "Se connecter", Constants.buttonFont, Color.WHITE, this::checkUpdateAndStartGame);
    public final SColoredBar progressBar = new SColoredBar(Constants.barBackground, Constants.barForeground);
    private final JLabel infoLabel = new JLabel("Progression", 0);
    private final CTransitionTexturedButton discordBtn = new CTransitionTexturedButton(Utils.getImageResource("discord.png"), this::discordBtnClick);
    private final CTransitionTexturedButton siteBtn = new CTransitionTexturedButton(Utils.getImageResource("site.png"), this::siteBtnClick);
    private final CTransitionTexturedButton settingsBtn = new CTransitionTexturedButton(Utils.getImageResource("settings.png"), this::settingsBtnClick);

    public MainLauncherPanel(LauncherFrame launcherFrame) {
        super(launcherFrame);
        this.setBackground(Swinger.TRANSPARENT);
        this.accountImage.setBounds(410, 177, 60, 60);
        this.add(this.accountImage);
        this.accountName.setBounds(475, 180, 200, 30);
        this.accountName.setForeground(Color.LIGHT_GRAY.brighter());
        this.accountName.setFont(Constants.defaultFont);
        this.add(this.accountName);
        this.accountType.setBounds(480, 207, 190, 20);
        this.accountType.setForeground(Color.LIGHT_GRAY);
        this.accountType.setFont(Constants.defaultFontSmall);
        this.add(this.accountType);
        this.changeAccountButton.setBounds(395, 152, 275, 110);
        this.add(this.changeAccountButton);
        this.connectBtn.setBounds(440, 362);
        this.add(this.connectBtn);
        this.progressBar.setBounds(0, 588, 1080, 20);
        this.add(this.progressBar);
        this.infoLabel.setBounds(0, 588, 1080, 20);
        this.infoLabel.setFont(Constants.defaultFontSmall);
        this.infoLabel.setForeground(new Color(255, 255, 255, 255));
        this.add(this.infoLabel);
        this.discordBtn.setBounds(10, 520, 50, 50);
        this.add(this.discordBtn);
        this.siteBtn.setBounds(80, 520, 50, 50);
        this.add(this.siteBtn);
        this.settingsBtn.setBounds(1010, 520, 50, 50);
        this.add(this.settingsBtn);
    }

    private void changeAccountBtnClick(AbstractButton button, MouseEvent e) {
        this.launcherFrame.displayAccountSelectionPanel();
    }

    private void checkUpdateAndStartGame(AbstractButton button, MouseEvent e) {
        SavedAccount selectedAccount = Settings.settings.connectedAccounts.getSelectedAccount();
        if (selectedAccount == null) {
            JOptionPane.showMessageDialog(this, "Merci d'ajouter votre compte avant de lancer le jeu.", "Erreur - Aventuros Launcher", 0);
            return;
        }
        this.setFieldsEnabled(false);
        File gameDir = Settings.settings.getFinalGameDir();
        gameDir.mkdirs();
        this.doUpdateAndStartGame(gameDir, selectedAccount);
    }

    private void doUpdateAndStartGame(File gameDir, SavedAccount selectedAccount) {
        this.launcherFrame.runInThreadAndThen(() -> this.launcherFrame.updater.update(gameDir)).thenAcceptSynced(unused -> {
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(100);
            this.doStartGame(gameDir, selectedAccount);
        }).exceptionally(e -> {
            if (!(e instanceof InterruptedException)) {
                Launcher.errorCatcher.catchError((Throwable)e, "Impossible de mettre \u00e0 jour le jeu");
            }
            this.resetProgress();
            return null;
        });
    }

    private void doStartGame(File gameDir, SavedAccount selectedAccount) {
        this.setInfoText("Ex\u00e9cution...");
        this.launcherFrame.runInThreadAndThen(() -> this.launcherFrame.gameLauncher.launch(gameDir, selectedAccount.username, selectedAccount.getAccessToken(), selectedAccount.getUUID())).thenAcceptSynced(restart -> {
            if (restart.booleanValue()) {
                this.progressBar.setValue(0);
                this.doUpdateAndStartGame(gameDir, Settings.settings.connectedAccounts.getSelectedAccount());
            } else {
                this.resetProgress();
            }
        }).exceptionally(e -> {
            if (e instanceof IOException) {
                Launcher.errorCatcher.catchError((Throwable)e, "Impossible de lancer le jeu");
            } else if (e instanceof InterruptedException) {
                Launcher.errorCatcher.catchError((Throwable)e, "Une erreur est survenue dans le launcher durant l'ex\u00e9cution du jeu !");
            }
            this.resetProgress();
            return null;
        });
    }

    private void resetProgress() {
        this.progressBar.setValue(0);
        this.setInfoText("Progression");
        this.setFieldsEnabled(true);
    }

    private void discordBtnClick(AbstractButton button, MouseEvent e) {
        try {
            Desktop.getDesktop().browse(new URI("https://aventuros.fr/discord/invite"));
        }
        catch (IOException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    private void siteBtnClick(AbstractButton button, MouseEvent e) {
        try {
            Desktop.getDesktop().browse(new URI("https://aventuros.fr/"));
        }
        catch (IOException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    private void settingsBtnClick(AbstractButton button, MouseEvent e) {
        new OptionFrame(this.launcherFrame).setVisible(true);
    }

    public void setFieldsEnabled(boolean enabled) {
        this.changeAccountButton.setEnabled(enabled);
        this.connectBtn.setEnabled(enabled);
        this.settingsBtn.setEnabled(enabled);
    }

    public void setInfoText(String text) {
        this.infoLabel.setText(text);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (e.getKeyCode() == 10) {
            this.connectBtn.simulatePress(null);
        }
    }

    public void updateSelectedAccountInfo(SavedAccount selectedAccount) {
        this.accountImage.setImage(selectedAccount.getHeadImage());
        this.accountName.setText(selectedAccount.username);
        this.accountType.setText(selectedAccount.getAccountTypeString());
    }

    @Override
    public void onDisplayed() {
        super.onDisplayed();
        SavedAccount selectedAccount = Settings.settings.connectedAccounts.getSelectedAccount();
        if (selectedAccount != null) {
            this.updateSelectedAccountInfo(selectedAccount);
        }
    }
}

