/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.panels;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fr.aventuros.launcher.Launcher;
import fr.aventuros.launcher.game.GameLogAnalyser;
import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.components.buttons.AbstractButton;
import fr.aventuros.launcher.gui.components.buttons.CTextRoundedBackgroundButton;
import fr.aventuros.launcher.gui.components.buttons.CTransitionTexturedButton;
import fr.aventuros.launcher.gui.panels.AbstractLauncherPanel;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.GraphicsUtils;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.http.MultipartFormdataBuilder;
import fr.theshark34.swinger.Swinger;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class CrashPanel
extends AbstractLauncherPanel {
    private static final URL logSubmitURL;
    private static final Font logsFont;
    private final File latestLogFile;
    private final String crashReportValue;

    public CrashPanel(LauncherFrame launcherFrame, GameLogAnalyser logAnalyser, File latestLogFile) {
        super(launcherFrame);
        String titleText;
        this.crashReportValue = logAnalyser.getValue();
        this.latestLogFile = latestLogFile;
        String logsText = this.crashReportValue;
        switch (logAnalyser.getLoggingState()) {
            case LOGGING_CRASH_REPORT: {
                logsText = logsText + "\n\nLa fin du crash report n'a pas pu \u00eatre trouv\u00e9e !";
            }
            case CRASH_REPORT_ENDED: {
                titleText = "Le jeu a plant\u00e9 !";
                break;
            }
            case IDLE: {
                logsText = "<Aucun logs ne sont disponibles>";
            }
            default: {
                titleText = "Le jeu s'est termin\u00e9 de fa\u00e7on anormale !";
            }
        }
        CTransitionTexturedButton closeButton = new CTransitionTexturedButton(Utils.getImageResource("close.png"), this::onClose);
        closeButton.setBounds(1030, 20, 40, 40);
        this.add(closeButton);
        JLabel titleLabel = new JLabel(titleText, 0);
        titleLabel.setFont(Constants.titleFont);
        titleLabel.setForeground(Color.WHITE);
        titleLabel.setBounds(0, 30, 1090, 50);
        this.add(titleLabel);
        JTextArea logTextArea = new JTextArea(logsText);
        logTextArea.setEditable(false);
        logTextArea.setLineWrap(true);
        logTextArea.setWrapStyleWord(true);
        logTextArea.setFont(logsFont);
        logTextArea.setForeground(Color.WHITE);
        logTextArea.setOpaque(false);
        logTextArea.setBackground(Swinger.TRANSPARENT);
        logTextArea.setCursor(new Cursor(2));
        JScrollPane scrollPane = new JScrollPane(logTextArea);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(false);
        scrollPane.setBounds(40, 90, 990, 450);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBorder(null);
        this.add(scrollPane);
        CTextRoundedBackgroundButton submitButton = new CTextRoundedBackgroundButton(400, 35, 10, Constants.buttonBackgroundColor, "Envoyer le rapport d'erreur", Constants.buttonFontSmall, Color.WHITE, this::onSubmit);
        submitButton.setBounds(340, 557);
        if (this.latestLogFile == null) {
            submitButton.setEnabled(false);
        }
        this.add(submitButton);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        GraphicsUtils.fillRoundRect(g, 40, 90, 990, 450, 10, Constants.darkBackgroundColor);
    }

    private void onClose(AbstractButton button, MouseEvent mouseEvent) {
        this.launcherFrame.displayMainPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSubmit(AbstractButton button, MouseEvent mouseEvent) {
        if (JOptionPane.showConfirmDialog(this, "Le rapport envoy\u00e9 ne sera visible que par les administrateurs et d\u00e9veloppeurs. Il contiendra les derniers logs du jeu, qui pourraient contenir les \u00e9l\u00e9ments sensibles suivants :\n- Le r\u00e9pertoire du jeu, qui peut contenir votre nom d'utilisateur sur votre ordinateur\n- Le pseudo Minecraft utilis\u00e9\n- Des informations syst\u00e8mes, comme votre carte graphique, votre processeur et votre syst\u00e8me d'exploitation\n\nConfirmez-vous l'envoi du rapport d'erreur ?", "Confirmation de l'envoi du rapport d'erreur - Aventuros Launcher", 2, 3) == 0) {
            InputStream responseStream;
            RandomAccessFile randomAccessFile;
            block7: {
                randomAccessFile = null;
                responseStream = null;
                try {
                    randomAccessFile = new RandomAccessFile(this.latestLogFile, "r");
                    long seek = Math.max(0L, randomAccessFile.length() - 131070L);
                    randomAccessFile.seek(seek);
                    if (seek > 0L) {
                        randomAccessFile.readLine();
                    }
                    HttpURLConnection connection = (HttpURLConnection)logSubmitURL.openConnection();
                    MultipartFormdataBuilder formdataBuilder = new MultipartFormdataBuilder(connection);
                    formdataBuilder.sendFile("gamelog", randomAccessFile, "gamelog.log");
                    formdataBuilder.sendField("error_report", this.crashReportValue);
                    formdataBuilder.finish();
                    responseStream = connection.getInputStream();
                    if (connection.getResponseCode() == 204) {
                        button.setEnabled(false);
                        JOptionPane.showMessageDialog(this, "Le rapport d'erreur a \u00e9t\u00e9 envoy\u00e9 !", "Aventuros Launcher", 1);
                        break block7;
                    }
                    JOptionPane.showMessageDialog(this, String.format("Une erreur est survenue lors de l'envoi du rapport d'erreur :\n%s", CrashPanel.getErrorMessage(responseStream)), "Erreur - Aventuros Launcher", 0);
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        Launcher.errorCatcher.catchError(e, "Une erreur est survenue lors de l'envoi du rapport d'erreur :");
                    }
                    catch (Throwable throwable) {
                        Utils.closeQuietly(randomAccessFile);
                        Utils.closeQuietly(responseStream);
                        throw throwable;
                    }
                    Utils.closeQuietly(randomAccessFile);
                    Utils.closeQuietly(responseStream);
                }
            }
            Utils.closeQuietly(randomAccessFile);
            Utils.closeQuietly(responseStream);
        }
    }

    private static String getErrorMessage(InputStream responseStream) throws IOException {
        JsonPrimitive primitive;
        JsonObject object;
        JsonElement explain;
        JsonElement element = JsonParser.parseReader(new InputStreamReader(responseStream, StandardCharsets.UTF_8));
        String errorMessage = "";
        if (element.isJsonObject() && (explain = (object = element.getAsJsonObject()).get("explain")).isJsonPrimitive() && (primitive = explain.getAsJsonPrimitive()).isString()) {
            errorMessage = primitive.getAsString();
        }
        return errorMessage;
    }

    static {
        try {
            logSubmitURL = new URL("https://aventuros.fr/api/error_report");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        logsFont = new Font("Consolas", 0, 11);
    }
}

