/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.panels;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.components.buttons.AbstractButton;
import fr.aventuros.launcher.gui.components.buttons.CTextRoundedBackgroundButton;
import fr.aventuros.launcher.gui.components.buttons.CTransitionTexturedButton;
import fr.aventuros.launcher.gui.panels.AbstractLauncherPanel;
import fr.aventuros.launcher.settings.SavedAccount;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.GraphicsUtils;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.mclauncherlib.utils.pair.ImmutablePair;
import fr.theshark34.swinger.Swinger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class AccountSelectionPanel
extends AbstractLauncherPanel {
    private static final int selectButtonWidth = 275;
    private static final int deleteButtonWidth = 60;
    private static final int panelWidthNoScroll = 335;
    private static final int panelWidth = 352;
    private static final int buttonHeight = 100;
    private static final BufferedImage buttonTextureTransparent = new BufferedImage(275, 100, 2);
    private static final BufferedImage buttonTextureHover = GraphicsUtils.getRectangle(275, 100, Swinger.HOVER_COLOR);
    private static final BufferedImage buttonTextureDisabled = GraphicsUtils.getRectangle(275, 100, Swinger.DISABLED_COLOR);
    private final CTransitionTexturedButton backBtn;
    private final JPanel scrollPanePanel;
    private final CTextRoundedBackgroundButton addButton;
    private final ArrayList<ImmutablePair<SelectAccountButton, DeleteAccountButton>> accountsList = new ArrayList();

    public AccountSelectionPanel(LauncherFrame launcherFrame) {
        super(launcherFrame);
        this.backBtn = new CTransitionTexturedButton(Utils.getImageResource("back.png"), (button, e) -> launcherFrame.displayMainPanel());
        this.backBtn.setBounds(20, 20, 40, 40);
        this.add(this.backBtn);
        JLabel title = new JLabel("S\u00e9lectionnez le compte \u00e0 utiliser, ou ajoutez-en un", 0);
        title.setBounds(245, 20, 600, 40);
        title.setFont(Constants.smallTitle);
        title.setForeground(Color.WHITE);
        this.add(title);
        this.scrollPanePanel = new JPanel(null);
        this.scrollPanePanel.setOpaque(false);
        this.scrollPanePanel.setBorder(null);
        Settings.settings.connectedAccounts.foreachAccount((index, account) -> {
            SelectAccountButton selectAccountButton = new SelectAccountButton(this, (int)index, (SavedAccount)account);
            DeleteAccountButton deleteAccountButton = new DeleteAccountButton(this, (int)index);
            this.scrollPanePanel.add(selectAccountButton);
            this.scrollPanePanel.add(deleteAccountButton);
            this.accountsList.add(new ImmutablePair<SelectAccountButton, DeleteAccountButton>(selectAccountButton, deleteAccountButton));
        });
        int accountsCount = Settings.settings.connectedAccounts.getAccountsCount();
        this.scrollPanePanel.setPreferredSize(new Dimension(335, accountsCount * 100 + 60));
        this.addButton = new CTextRoundedBackgroundButton(335, 50, 0, Constants.buttonBackgroundColor, "Ajouter un compte", Constants.buttonFontSmall, Color.WHITE, this::addAccount);
        this.addButton.setBounds(0, accountsCount * 100 + 5, 335, 50);
        this.scrollPanePanel.add(this.addButton);
        JScrollPane scrollPane = new JScrollPane(this.scrollPanePanel, 22, 31);
        scrollPane.setBounds(369, 80, 352, 500);
        scrollPane.getVerticalScrollBar().setUnitIncrement(8);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    private void addAccount(AbstractButton button, MouseEvent mouseEvent) {
        this.launcherFrame.displayAccountConnectionPanel(this);
    }

    private void deleteAccount(int index) {
        int i;
        Settings.settings.connectedAccounts.removeAccount(index);
        Settings.settings.save();
        if (Settings.settings.connectedAccounts.hasNoAccounts()) {
            this.launcherFrame.displayAccountConnectionPanel(null);
        }
        ArrayList<ImmutablePair<SelectAccountButton, DeleteAccountButton>> list = this.accountsList;
        ImmutablePair<SelectAccountButton, DeleteAccountButton> entry = list.remove(index);
        this.scrollPanePanel.remove((Component)entry.a);
        this.scrollPanePanel.remove((Component)entry.b);
        for (i = 0; i < list.size(); ++i) {
            entry = list.get(i);
            if (i < index) continue;
            ((SelectAccountButton)entry.a).setBounds(0, ((SelectAccountButton)entry.a).getY() - 100);
            ((SelectAccountButton)entry.a).index--;
            ((DeleteAccountButton)entry.b).setBounds(275, ((DeleteAccountButton)entry.b).getY() - 100);
            ((DeleteAccountButton)entry.b).index--;
        }
        this.addButton.setBounds(0, this.addButton.getY() - 100);
        this.scrollPanePanel.setPreferredSize(new Dimension(335, i * 100 + 60));
    }

    private void selectAccount(int index) {
        Settings.settings.connectedAccounts.selectedIndex = index;
        Settings.settings.save();
        this.launcherFrame.displayMainPanel();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        GraphicsUtils.fillRoundRect(g, 369, 80, 352, 500, 10, Constants.darkBackgroundColor);
    }

    private static class DeleteAccountButton
    extends CTransitionTexturedButton {
        private static final BufferedImage textureNormal;
        private static final BufferedImage textureHover;
        private static final BufferedImage textureDisabled;
        private final AccountSelectionPanel parent;
        private int index;

        public DeleteAccountButton(AccountSelectionPanel parent, int index) {
            super(textureNormal, textureHover, textureDisabled, null);
            this.parent = parent;
            this.index = index;
            this.setBounds(275, index * 100 + 5, 60, 100);
        }

        @Override
        protected void onPress() {
            super.onPress();
            this.parent.deleteAccount(this.index);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 99, 60, 1);
        }

        static {
            BufferedImage deleteImage = Utils.getImageResource("delete_white.png");
            int x = (60 - deleteImage.getWidth()) / 2;
            int y = (100 - deleteImage.getHeight()) / 2;
            textureNormal = new BufferedImage(60, 100, 2);
            textureNormal.getGraphics().drawImage(deleteImage, x, y, null);
            textureHover = GraphicsUtils.getRectangle(60, 100, Swinger.HOVER_COLOR);
            textureHover.getGraphics().drawImage(deleteImage, x, y, null);
            textureDisabled = GraphicsUtils.getRectangle(60, 100, Swinger.DISABLED_COLOR);
            textureDisabled.getGraphics().drawImage(deleteImage, x, y, null);
        }
    }

    private static class SelectAccountButton
    extends CTransitionTexturedButton {
        private final AccountSelectionPanel parent;
        private int index;
        private final SavedAccount savedAccount;

        public SelectAccountButton(AccountSelectionPanel parent, int index, SavedAccount savedAccount) {
            super(buttonTextureTransparent, buttonTextureHover, buttonTextureDisabled, null);
            this.parent = parent;
            this.index = index;
            this.savedAccount = savedAccount;
            this.setBounds(0, index * 100 + 5, 275, 100);
        }

        @Override
        protected void onPress() {
            super.onPress();
            this.parent.selectAccount(this.index);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.savedAccount.getHeadImage(), 15, 20, 60, 60, this);
            g.setColor(Color.LIGHT_GRAY.brighter());
            g.setFont(Constants.defaultFont);
            g.drawString(this.savedAccount.username, 80, 50);
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(Constants.defaultFontSmall);
            g.drawString(this.savedAccount.getAccountTypeString(), 85, 68);
            g.fillRect(0, 99, 275, 1);
        }
    }
}

