/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.panels;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.MicrosoftLoginFrame;
import fr.aventuros.launcher.gui.components.CRoundedRectangle;
import fr.aventuros.launcher.gui.components.buttons.AbstractButton;
import fr.aventuros.launcher.gui.components.buttons.CTextRoundedBackgroundButton;
import fr.aventuros.launcher.gui.components.buttons.CTransitionTexturedButton;
import fr.aventuros.launcher.gui.panels.AbstractLauncherPanel;
import fr.aventuros.launcher.settings.SavedAccount;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.PremiumTest;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.data.MicrosoftAuthResult;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticationException;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class AccountConnectionPanel
extends AbstractLauncherPanel {
    private final CTransitionTexturedButton backBtn;
    private final CTextRoundedBackgroundButton microsoftBtn = new CTextRoundedBackgroundButton(215, 45, 10, Constants.buttonBackgroundColor, "Compte Microsoft", Constants.buttonFontSmall, Color.WHITE, this::microsoftBtnClick);
    private final CTextRoundedBackgroundButton crackedBtn = new CTextRoundedBackgroundButton(215, 45, 10, Constants.buttonBackgroundColor, "Compte Crack", Constants.buttonFontSmall, Color.WHITE, this::crackedBtnClick);

    public AccountConnectionPanel(LauncherFrame launcherFrame, AbstractLauncherPanel previousPanel) {
        super(launcherFrame);
        if (previousPanel == null) {
            this.backBtn = null;
        } else {
            this.backBtn = new CTransitionTexturedButton(Utils.getImageResource("back.png"), (button, e) -> launcherFrame.setContentPane(previousPanel));
            this.backBtn.setBounds(20, 20, 40, 40);
            this.add(this.backBtn);
        }
        JLabel title = new JLabel("S\u00e9lectionnez le type de compte \u00e0 ajouter", 0);
        title.setBounds(245, 20, 600, 40);
        title.setFont(Constants.smallTitle);
        title.setForeground(Color.WHITE);
        this.add(title);
        this.microsoftBtn.setBounds(438, 180);
        this.add(this.microsoftBtn);
        this.crackedBtn.setBounds(438, 260);
        this.add(this.crackedBtn);
        CRoundedRectangle fieldsBack = new CRoundedRectangle(Constants.lightDarkBackgroundColor, 10);
        fieldsBack.setBounds(348, 125, 395, 200);
        this.add(fieldsBack);
    }

    private void microsoftBtnClick(AbstractButton button, MouseEvent e) {
        this.setFieldsEnabled(false);
        ((CompletableFuture)MicrosoftLoginFrame.start(this.launcherFrame).thenAcceptAsync(microsoftAuthResult -> {
            SavedAccount.MicrosoftSavedAccount newAccount;
            try {
                newAccount = new SavedAccount.MicrosoftSavedAccount((MicrosoftAuthResult)microsoftAuthResult);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            Settings.settings.connectedAccounts.addAccount(newAccount);
            Settings.settings.save();
            this.launcherFrame.displayMainPanel();
        })).exceptionally(throwable -> {
            block7: {
                String errorMessage;
                block6: {
                    block5: {
                        errorMessage = null;
                        if (!(throwable instanceof InterruptedException)) break block5;
                        errorMessage = "L'op\u00e9ration a \u00e9t\u00e9 interrompue";
                        break block6;
                    }
                    if (!(throwable instanceof CompletionException)) break block6;
                    if ((throwable = throwable.getCause()) instanceof CancellationException) break block7;
                    if (throwable instanceof MicrosoftAuthenticationException) {
                        errorMessage = String.format("La connexion a compte Microsoft a \u00e9chou\u00e9e\u00a0:\n%s", throwable.getMessage());
                    }
                }
                if (errorMessage == null) {
                    errorMessage = String.format("Une erreur inconnue est survenue\u00a0: %s", throwable);
                }
                JOptionPane.showMessageDialog(this, errorMessage, "Connexion au compte Microsoft", 0);
            }
            this.setFieldsEnabled(true);
            this.launcherFrame.setContentPane(this);
            return null;
        });
    }

    private void crackedBtnClick(AbstractButton button, MouseEvent e) {
        String result;
        this.setFieldsEnabled(false);
        SavedAccount selectedAccount = Settings.settings.connectedAccounts.getSelectedAccount();
        String string = result = selectedAccount instanceof SavedAccount.CrackedSavedAccount ? selectedAccount.username : "";
        while ((result = (String)JOptionPane.showInputDialog(this, "Entrez le pseudo de votre choix", "", 3, null, null, result)) != null) {
            if (SavedAccount.CrackedSavedAccount.isUsernameInvalid(result)) {
                JOptionPane.showMessageDialog(this, "Le pseudo ne peux contenir que des lettres, des chiffres et des tirets de soulignement. Il doit \u00e9galement contenir entre 3 et 16 caract\u00e8res.", "Pseudo invalide", 0);
                continue;
            }
            PremiumTest premiumTest = PremiumTest.get(result);
            if (premiumTest.errorMessage != null) {
                JOptionPane.showMessageDialog(this, "Nous n'avons pas pu v\u00e9rifier que le pseudo utilis\u00e9 n'est pas d\u00e9j\u00e0 utilis\u00e9 par un compte premium. Il est possible que vous rencrontriez des difficult\u00e9s pour vous connecter au serveur, ou que vous ne puissiez pas du tout.", "Impossible de v\u00e9rifier le pseudo", 2);
            } else if (premiumTest.uuid != null) {
                JOptionPane.showMessageDialog(this, "Ce pseudo est d\u00e9j\u00e0 utilis\u00e9 par un compte premium. Il vous sera impossible de vous connecter au serveur avec.", "Pseudo invalide", 0);
                continue;
            }
            Settings.settings.connectedAccounts.addAccount(new SavedAccount.CrackedSavedAccount(result));
            Settings.settings.save();
            this.launcherFrame.displayMainPanel();
            break;
        }
        this.setFieldsEnabled(true);
    }

    private void setFieldsEnabled(boolean enabled) {
        this.microsoftBtn.setEnabled(enabled);
        this.crackedBtn.setEnabled(enabled);
    }
}

