/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.panels;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.components.buttons.AbstractButton;
import fr.aventuros.launcher.utils.Utils;
import fr.theshark34.swinger.Swinger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class AbstractLauncherPanel
extends JPanel {
    protected static final BufferedImage backgroundResource = Utils.getImageResource("background.png");
    protected final LauncherFrame launcherFrame;

    public AbstractLauncherPanel(LauncherFrame launcherFrame) {
        super(null);
        this.launcherFrame = launcherFrame;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Swinger.drawFullsizedImage(g, this, backgroundResource);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void onReplaced() {
    }

    public void onDisplayed() {
        AbstractLauncherPanel.checkComponentsOnDisplay(this);
    }

    private static void checkComponentsOnDisplay(Container container) {
        for (Component subComponent : container.getComponents()) {
            if (subComponent instanceof Container) {
                AbstractLauncherPanel.checkComponentsOnDisplay((Container)subComponent);
            }
            if (!(subComponent instanceof AbstractButton)) continue;
            ((AbstractButton)subComponent).setNotHovered();
        }
    }
}

