/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.components.buttons;

import fr.aventuros.launcher.gui.components.buttons.AbstractButton;
import fr.aventuros.launcher.gui.components.buttons.ButtonClickHandler;
import fr.aventuros.launcher.utils.GraphicsUtils;
import fr.theshark34.swinger.Swinger;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Timer;

public class CTransitionTexturedButton
extends AbstractButton {
    public static final long defaultTransitionLength = 250L;
    private BufferedImage texture;
    private BufferedImage textureHover;
    private BufferedImage textureDisabled;
    private BufferedImage textureCurrent;
    private int width;
    private int height;
    private long transitionDuration;
    private long transitionStart;
    private Timer transitionTimer;

    public CTransitionTexturedButton(BufferedImage texture, ButtonClickHandler buttonClickHandler) {
        this(texture, 250L, buttonClickHandler);
    }

    public CTransitionTexturedButton(BufferedImage texture, long transitionDuration, ButtonClickHandler buttonClickHandler) {
        super(buttonClickHandler);
        this.textureCurrent = texture;
        this.transitionDuration = transitionDuration;
        this.setTexture(texture);
    }

    public CTransitionTexturedButton(BufferedImage texture, BufferedImage textureHover, BufferedImage textureDisabled, ButtonClickHandler buttonClickHandler) {
        this(texture, textureHover, textureDisabled, 250L, buttonClickHandler);
    }

    public CTransitionTexturedButton(BufferedImage texture, BufferedImage textureHover, BufferedImage textureDisabled, long transitionDuration, ButtonClickHandler buttonClickHandler) {
        super(buttonClickHandler);
        this.textureCurrent = texture;
        this.transitionDuration = transitionDuration;
        this.setTexture(texture, textureHover, textureDisabled);
    }

    public void setTexture(BufferedImage texture, BufferedImage textureHover, BufferedImage textureDisabled) {
        this.texture = texture;
        this.textureHover = textureHover;
        this.textureDisabled = textureDisabled;
        this.width = texture.getWidth(this.getParent());
        this.height = texture.getHeight(this.getParent());
        this.repaint();
    }

    public void setTexture(BufferedImage texture) {
        this.setTexture(texture, GraphicsUtils.fillImageByTransparency(texture, Swinger.HOVER_COLOR), GraphicsUtils.fillImageByTransparency(texture, Swinger.DISABLED_COLOR));
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public long getTransitionDuration() {
        return this.transitionDuration;
    }

    public void setTransitionDuration(long transitionDuration) {
        this.transitionDuration = transitionDuration;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        if (this.isEnabled()) {
            this.startTransition(this.textureHover);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        if (this.isEnabled()) {
            this.startTransition(this.texture);
        }
    }

    @Override
    public void setNotHovered() {
        super.setNotHovered();
        if (this.transitionTimer != null && this.transitionTimer.isRunning()) {
            this.transitionTimer.stop();
        }
        this.textureCurrent = this.texture;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.startTransition(this.texture);
        } else {
            this.startTransition(this.textureDisabled);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawComponents(g, this.textureCurrent);
    }

    protected void drawComponents(Graphics g, BufferedImage texture) {
        Swinger.drawFullsizedImage(g, this, texture);
        if (this.getText() != null) {
            Swinger.activateAntialias(g);
            if (this.getTextColor() != null) {
                g.setColor(this.getTextColor());
            }
            GraphicsUtils.drawCenteredString(g, this.getText(), this.getBounds());
        }
    }

    private void startTransition(BufferedImage destinationImage) {
        if (this.transitionTimer != null && this.transitionTimer.isRunning()) {
            this.transitionTimer.stop();
        }
        BufferedImage startImage = this.textureCurrent;
        this.transitionStart = System.currentTimeMillis();
        this.transitionTimer = new Timer(20, e -> {
            long elapsedTime = System.currentTimeMillis() - this.transitionStart;
            if (elapsedTime > this.transitionDuration) {
                this.textureCurrent = destinationImage;
                this.transitionTimer.stop();
                this.transitionTimer = null;
            } else {
                float progress = (float)elapsedTime / (float)this.transitionDuration;
                this.textureCurrent = GraphicsUtils.blendImages(startImage, destinationImage, progress);
            }
            this.repaint();
        });
        this.transitionTimer.start();
    }

    public void setBounds(int x, int y) {
        super.setBounds(x, y, this.width, this.height);
    }
}

