/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.components.buttons;

import fr.aventuros.launcher.gui.components.buttons.ButtonClickHandler;
import fr.aventuros.launcher.gui.components.buttons.CTransitionTexturedButton;
import fr.aventuros.launcher.utils.GraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class CTextRoundedBackgroundButton
extends CTransitionTexturedButton {
    protected int arcSize;
    protected Color backgroundColor;

    public CTextRoundedBackgroundButton(int width, int height, int arcSize, Color backgroundColor, String text, Font font, Color textColor, long transitionDuration, ButtonClickHandler buttonClickHandler) {
        super(GraphicsUtils.getRoundedCornerRectangle(width, height, arcSize, backgroundColor), transitionDuration, buttonClickHandler);
        this.arcSize = arcSize;
        this.backgroundColor = backgroundColor;
        this.setText(text);
        this.setFont(font);
        this.setTextColor(textColor);
    }

    public CTextRoundedBackgroundButton(int width, int height, int arcSize, Color backgroundColor, String text, Font font, Color textColor, ButtonClickHandler buttonClickHandler) {
        this(width, height, arcSize, backgroundColor, text, font, textColor, 250L, buttonClickHandler);
    }

    private void regenerateTexture() {
        Rectangle rectangle = this.getBounds();
        this.setTexture(GraphicsUtils.getRoundedCornerRectangle(rectangle.width, rectangle.height, this.arcSize, this.backgroundColor));
    }

    public int getArcSize() {
        return this.arcSize;
    }

    public void setArcSize(int arcSize) {
        this.arcSize = arcSize;
        this.regenerateTexture();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.regenerateTexture();
    }
}

