/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.components.buttons;

import fr.aventuros.launcher.gui.components.buttons.ButtonClickHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public abstract class AbstractButton
extends JComponent
implements MouseListener {
    private final ButtonClickHandler buttonClickHandler;
    private String text;
    private Color textColor;
    private boolean hover;

    public AbstractButton(ButtonClickHandler buttonClickHandler) {
        this.buttonClickHandler = buttonClickHandler;
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.simulatePress(e);
        }
    }

    public void simulatePress(MouseEvent e) {
        if (this.isEnabled()) {
            this.onPress();
            if (this.buttonClickHandler != null) {
                this.buttonClickHandler.onLeftClick(this, e);
            }
        }
    }

    protected void onPress() {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hover = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hover = false;
        this.repaint();
    }

    public void setNotHovered() {
        this.hover = false;
        this.repaint();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        System.out.println("Mouse move");
        if (this.hover) {
            Point mouseRelative = e.getPoint();
            if (mouseRelative.x < 0 || mouseRelative.x > this.getWidth() || mouseRelative.y < 0 && mouseRelative.y > this.getHeight()) {
                this.mouseExited(e);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint();
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(Color textColor) {
        if (textColor == null) {
            throw new IllegalArgumentException("textColor == null");
        }
        this.textColor = textColor;
        this.repaint();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public boolean isHover() {
        return this.hover;
    }
}

