/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui.components;

import fr.aventuros.launcher.utils.GraphicsUtils;
import fr.theshark34.swinger.Swinger;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;

public class CWaitingProgressBar
extends JComponent {
    private static final int defaultSpeed = 3;
    private final int fgSize;
    private final int speed;
    private int minX = 0;
    private boolean toRight = true;

    public CWaitingProgressBar(Color background, Color foreground) {
        this(background, foreground, 30, 3);
    }

    public CWaitingProgressBar(Color background, Color foreground, int fgSize) {
        this(background, foreground, fgSize, 3);
    }

    public CWaitingProgressBar(Color background, Color foreground, int fgSize, int speed) {
        this.setBackground(background);
        this.setForeground(foreground);
        this.fgSize = fgSize;
        this.speed = speed;
        Timer updateTimer = new Timer();
        updateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                CWaitingProgressBar.this.repaint();
            }
        }, 20L, 10L);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Swinger.fillFullsizedRect(g, this, this.getBackground());
        this.minX += this.toRight ? this.speed : -this.speed;
        if (this.minX <= 0 || this.minX + this.fgSize > this.getWidth()) {
            this.toRight = !this.toRight;
        }
        GraphicsUtils.fillRect(g, Math.max(this.minX, 0), 0, Math.min(this.getWidth(), this.fgSize), this.getHeight(), this.getForeground());
    }
}

