/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.OperatingSystem;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public final class OptionFrame
extends JDialog {
    private static final String[] RAM_ARRAY;
    private static final String[] RAM_ARGUMENTS;
    private final JComboBox<String> ramBox;
    private final JTextField gamedirField;
    private final JCheckBox defaultGamedirBox;
    private final JCheckBox betterfpsModBox;

    public OptionFrame(LauncherFrame launcherFrame) {
        super(launcherFrame, "Options - Aventuros Launcher", true);
        this.setIconImage(LauncherFrame.iconImage);
        this.setResizable(false);
        this.setLocationRelativeTo(launcherFrame);
        this.setLayout(null);
        this.setDefaultCloseOperation(2);
        int y = 15;
        JLabel ramLabel = new JLabel("Ram:");
        ramLabel.setBounds(15, y, 150, 25);
        this.add(ramLabel);
        this.ramBox = new JComboBox<String>(RAM_ARRAY);
        this.ramBox.setBounds(150, y, 195, 25);
        this.ramBox.setSelectedIndex(OptionFrame.clampRamIndex(Settings.settings.gameSettings.ram));
        this.add(this.ramBox);
        y += 25;
        if (OperatingSystem.is32Bits) {
            JLabel ramWarningLabel = new JLabel("La RAM est limit\u00e9e \u00e0 2\u00a0Go par la version 32 bits de Java !");
            ramWarningLabel.setBounds(25, y, 355, 20);
            ramWarningLabel.setForeground(Color.RED);
            this.add(ramWarningLabel);
            y += 20;
        }
        JLabel gamedirLabel = new JLabel("R\u00e9pertoire de jeu:");
        gamedirLabel.setBounds(15, y += 20, 150, 25);
        this.add(gamedirLabel);
        this.gamedirField = new JTextField();
        this.gamedirField.setBounds(150, y, 195, 25);
        this.defaultGamedirBox = new JCheckBox("Utiliser le r\u00e9pertoire par d\u00e9faut");
        this.defaultGamedirBox.setBounds(25, y += 25, 195, 25);
        this.defaultGamedirBox.addChangeListener(e -> {
            if (this.defaultGamedirBox.isSelected()) {
                this.gamedirField.setText("");
                this.gamedirField.setEnabled(false);
            } else {
                this.gamedirField.setEnabled(true);
            }
        });
        File gameDir = Settings.settings.getSettingGameDir();
        if (gameDir == null) {
            this.defaultGamedirBox.setSelected(true);
            this.gamedirField.setEnabled(false);
        } else {
            this.defaultGamedirBox.setSelected(false);
            this.gamedirField.setEnabled(true);
            this.gamedirField.setText(gameDir.getAbsolutePath());
        }
        this.add(this.gamedirField);
        this.add(this.defaultGamedirBox);
        JLabel additionalMods = new JLabel("Mods suppl\u00e9mentaires:");
        additionalMods.setBounds(15, y += 35, 150, 20);
        this.add(additionalMods);
        this.betterfpsModBox = new JCheckBox("BetterFPS (Version Beta)");
        this.betterfpsModBox.setBounds(25, y += 20, 150, 20);
        this.betterfpsModBox.setSelected(Settings.settings.additionalMods.betterfps);
        this.add(this.betterfpsModBox);
        this.setSize(380, y + 20 + 50);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            File gameDir;
            if (this.defaultGamedirBox.isSelected()) {
                gameDir = null;
            } else {
                String gameDirPath = this.gamedirField.getText().trim();
                if (gameDirPath.isEmpty()) {
                    gameDir = null;
                    this.defaultGamedirBox.setSelected(true);
                } else {
                    gameDir = new File(gameDirPath);
                    if (!gameDir.exists() && !gameDir.mkdirs()) {
                        JOptionPane.showMessageDialog(this, "Le chemin du r\u00e9pertoire de jeu est invalide !", "Erreur - Aventuros Launcher", 0);
                        return;
                    }
                }
            }
            Settings.settings.gameSettings.ram = this.ramBox.getSelectedIndex();
            Settings.settings.additionalMods.betterfps = this.betterfpsModBox.isSelected();
            Settings.settings.setGameDir(gameDir);
        }
        super.processWindowEvent(e);
    }

    public static int clampRamIndex(int index) {
        if (index < 0) {
            return 0;
        }
        if (index >= RAM_ARRAY.length) {
            return RAM_ARRAY.length - 1;
        }
        return index;
    }

    public static List<String> getRamArguments() {
        String ramArgument = RAM_ARGUMENTS[OptionFrame.clampRamIndex(Settings.settings.gameSettings.ram)];
        return Arrays.asList("-Xms" + ramArgument, "-Xmx" + ramArgument);
    }

    static {
        if (OperatingSystem.is32Bits) {
            RAM_ARRAY = new String[]{"1.5\u00a0Go", "2\u00a0Go (recommand\u00e9)"};
            RAM_ARGUMENTS = new String[]{"1536M", "2000M"};
        } else {
            RAM_ARRAY = new String[]{"1.5\u00a0Go", "2\u00a0Go (recommand\u00e9)", "3\u00a0Go", "4\u00a0Go"};
            RAM_ARGUMENTS = new String[]{"1536M", "2G", "3G", "4G"};
        }
    }
}

