/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.data.MicrosoftAuthResult;
import fr.aventuros.mclauncherlib.Authentification;
import fr.litarvan.openauth.microsoft.AuthTokens;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticationException;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class MicrosoftLoginFrame
extends JFrame {
    private static final String START_URL = "https://login.live.com/oauth20_authorize.srf?client_id=000000004C12AE6F&redirect_uri=https%3A//login.live.com/oauth20_desktop.srf&scope=service%3A%3Auser.auth.xboxlive.com%3A%3AMBI_SSL&response_type=token";
    private static final String END_URL = "https://login.live.com/oauth20_desktop.srf";
    private static final CookieManager cookieManager = new CookieManager();
    private final CompletableFuture<MicrosoftAuthResult> future;
    private final JFXPanel jfxPanel;

    private MicrosoftLoginFrame(CompletableFuture<MicrosoftAuthResult> future) {
        super("Aventuros Launcher - Connexion au compte Microsoft");
        this.future = future;
        this.jfxPanel = new JFXPanel();
        this.setDefaultCloseOperation(2);
        this.setSize(750, 750);
        this.setResizable(false);
        this.setContentPane((Container)this.jfxPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MicrosoftLoginFrame.this.future.cancel(false);
            }
        });
        Platform.runLater(this::init);
    }

    public static CompletableFuture<MicrosoftAuthResult> start(LauncherFrame launcherFrame) {
        CompletableFuture<MicrosoftAuthResult> future;
        block6: {
            future = new CompletableFuture<MicrosoftAuthResult>();
            if (launcherFrame.isKeyPressed(17)) {
                try {
                    Desktop.getDesktop().browse(new URI(START_URL));
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                while (true) {
                    String url;
                    if ((url = JOptionPane.showInputDialog(launcherFrame, String.format("Connectez-vous dans la page qui vient d'\u00eatre ouverte dans votre navigateur, puis copiez l'URL une fois la connexion termin\u00e9e dans le champ si dessous.\n\nNote : Si vous \u00eates d\u00e9j\u00e0 connect\u00e9 \u00e0 votre compte Microsoft dans votre navigateur, vous serez automatiquement redirig\u00e9 sur la page finale.\nVous pouvez la reconna\u00eetre par une page enti\u00e8rement blanche et dont l'URL commence par %s et contient \"access_token\".\nUne fois l'op\u00e9ration termin\u00e9e, vous pourrez ensuite fermer la page.\n\nAttention, traitez cette URL comme un mot de passe car elle permet de se connecter \u00e0 votre compte.", END_URL), "Authentification manuelle - Aventuros Launcher", 1)) == null) {
                        future.cancel(false);
                        break block6;
                    }
                    if (url.startsWith(END_URL)) {
                        MicrosoftLoginFrame.emptyKeyboardIfEquals(url);
                        MicrosoftLoginFrame.extractAuthentificationResult(url, future);
                        break block6;
                    }
                    JOptionPane.showMessageDialog(launcherFrame, "Veuillez entrer l'URL finale apr\u00e8s la connexion !", "URL invalide", 0);
                }
            }
            MicrosoftLoginFrame frame = new MicrosoftLoginFrame(future);
            frame.setLocationRelativeTo(launcherFrame);
        }
        return future;
    }

    private static void emptyKeyboardIfEquals(String string) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String contents = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (string.equals(contents)) {
                StringSelection selection = new StringSelection("");
                clipboard.setContents(selection, selection);
            }
        }
        catch (UnsupportedFlavorException clipboard) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void init() {
        cookieManager.getCookieStore().removeAll();
        WebView webView = new WebView();
        WebEngine webEngine = webView.getEngine();
        webEngine.setJavaScriptEnabled(true);
        this.jfxPanel.setScene(new Scene((Parent)webView, (double)this.jfxPanel.getWidth(), (double)this.jfxPanel.getHeight()));
        webEngine.locationProperty().addListener(this::onLocationChange);
        webEngine.load(START_URL);
        this.setVisible(true);
    }

    private void onLocationChange(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (newValue.startsWith(END_URL)) {
            this.dispose();
            MicrosoftLoginFrame.extractAuthentificationResult(newValue, this.future);
        }
    }

    private static void extractAuthentificationResult(String url, CompletableFuture<MicrosoftAuthResult> future) {
        block5: {
            try {
                Map<String, String> parameters = MicrosoftLoginFrame.extractParameters(url);
                String error = parameters.get("error");
                if (error == null) {
                    long expireAt = Utils.currentTimeSec() + Long.parseLong(parameters.get("expires_in"));
                    future.complete(new MicrosoftAuthResult(Authentification.microsoftAuthTokens(new AuthTokens(parameters.get("access_token"), parameters.get("refresh_token"))), expireAt));
                    break block5;
                }
                if (error.equals("access_denied")) {
                    future.cancel(false);
                    break block5;
                }
                String errorDescription = parameters.get("error_description");
                if (errorDescription != null) {
                    error = error + "\n" + errorDescription;
                }
                throw new MicrosoftAuthenticationException(error);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        }
    }

    private static Map<String, String> extractParameters(String url) throws MicrosoftAuthenticationException {
        int firstHashIndex = url.indexOf(35);
        if (firstHashIndex > -1 && firstHashIndex == url.lastIndexOf(35)) {
            String[] params = url.split("#", 2)[1].split("&");
            HashMap<String, String> result = new HashMap<String, String>();
            for (String param : params) {
                String[] paramSplit = param.split("=", 2);
                try {
                    result.put(paramSplit[0], URLDecoder.decode(paramSplit[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MicrosoftAuthenticationException(e);
                }
            }
            return result;
        }
        throw new MicrosoftAuthenticationException("Invalid return URL");
    }

    static {
        CookieHandler.setDefault(cookieManager);
        Platform.setImplicitExit((boolean)false);
    }
}

