/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.gui;

import com.sun.istack.internal.Nullable;
import fr.aventuros.launcher.game.GameLauncher;
import fr.aventuros.launcher.game.Updater;
import fr.aventuros.launcher.gui.panels.AbstractLauncherPanel;
import fr.aventuros.launcher.gui.panels.AccountConnectionPanel;
import fr.aventuros.launcher.gui.panels.AccountSelectionPanel;
import fr.aventuros.launcher.gui.panels.MainLauncherPanel;
import fr.aventuros.launcher.gui.panels.SplashPanel;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.launcher.utils.concurrent.FrameCompletableFuture;
import fr.aventuros.launcher.utils.concurrent.NoExceptionCallable;
import fr.aventuros.launcher.utils.concurrent.ThrowableCallable;
import fr.aventuros.launcher.utils.concurrent.ThrowableRunnable;
import fr.theshark34.swinger.Swinger;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class LauncherFrame
extends JFrame
implements KeyListener {
    private final HashSet<Integer> pressedKeys = new HashSet();
    public static final BufferedImage iconImage = Utils.getImageResource("icon.png");
    public final Updater updater;
    public final GameLauncher gameLauncher;
    public final MainLauncherPanel mainPanel;
    @Nullable
    private AbstractLauncherPanel visiblePanel;

    public LauncherFrame() {
        super("Aventuros Launcher");
        this.setSize(1090, 647);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setIconImage(iconImage);
        this.getContentPane().setBackground(Swinger.TRANSPARENT);
        this.mainPanel = new MainLauncherPanel(this);
        this.updater = new Updater(this);
        this.gameLauncher = new GameLauncher(this);
        this.addKeyListener(this);
        this.setContentPane(new SplashPanel(this));
        this.setVisible(true);
    }

    public void displayMainPanel() {
        if (Settings.settings.connectedAccounts.hasNoAccounts()) {
            this.displayAccountConnectionPanel(null);
        } else {
            this.setContentPane(this.mainPanel);
        }
    }

    public void displayAccountSelectionPanel() {
        this.setContentPane(new AccountSelectionPanel(this));
    }

    public void displayAccountConnectionPanel(AbstractLauncherPanel previous) {
        this.setContentPane(new AccountConnectionPanel(this, previous));
    }

    @Override
    public void setContentPane(Container container) {
        if (this.visiblePanel != null) {
            this.visiblePanel.onReplaced();
        }
        if (container instanceof AbstractLauncherPanel) {
            this.visiblePanel = (AbstractLauncherPanel)container;
            this.visiblePanel.onDisplayed();
        } else {
            this.visiblePanel = null;
        }
        super.setContentPane(container);
        this.validate();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            String warnMsg = this.updater.isRunning() ? "Un t\u00e9l\u00e9chargement est actutellement en cours. En fermant le launcher, celui-ci va se terminer. \u00cates-vous s\u00fbr ?" : (this.gameLauncher.isRunning() ? "Le jeu est actuellement en cours d'ex\u00e9cution. En fermant le launcher, celui-ci va se fermer. \u00cates-vous s\u00fbr ?" : null);
            if (warnMsg != null) {
                if (0 != JOptionPane.showConfirmDialog(this, warnMsg, "Avertissement - Aventuros Launcher", 0, 2)) {
                    return;
                }
                this.updater.cancelUpdate();
                this.gameLauncher.closeProcess();
            }
            this.dispose();
            System.exit(0);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pressedKeys.add(e.getKeyCode());
        if (this.visiblePanel != null) {
            this.visiblePanel.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.pressedKeys.remove(e.getKeyCode());
    }

    public boolean isKeyPressed(int keyCode) {
        return this.pressedKeys.contains(keyCode);
    }

    public void sendToFront() {
        this.toFront();
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    public void invokeAndWaitNoException(Runnable runnable) {
        try {
            this.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V invokeAndWait(NoExceptionCallable<V> callable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            return callable.call();
        }
        Object[] returnValue = new Object[1];
        EventQueue.invokeAndWait(() -> {
            returnValue[0] = callable.call();
        });
        return (V)returnValue[0];
    }

    public <V> V invokeAndWaitNoException(NoExceptionCallable<V> callable) {
        try {
            return this.invokeAndWait(callable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public FrameCompletableFuture<Void> runInThreadAndThen(ThrowableRunnable runnable) {
        return this.runInThreadAndThen(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> FrameCompletableFuture<T> runInThreadAndThen(ThrowableCallable<T> callable) {
        FrameCompletableFuture future = new FrameCompletableFuture(this);
        new Thread(() -> {
            try {
                future.complete(callable.call());
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        }).start();
        return future;
    }
}

