/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.game;

import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.panels.MainLauncherPanel;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.OperatingSystem;
import fr.aventuros.mclauncherlib.filesupdater.DownloadSource;
import fr.aventuros.mclauncherlib.filesupdater.DownloadStatus;
import fr.aventuros.mclauncherlib.filesupdater.LauncherFilesUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class Updater {
    private static final String[] ignorelist = new String[]{"options.txt", "optionsof.txt", "crash-reports", "logs", "resourcepacks", "screenshots", "shaderpacks", "launcher.properties", "optionsshaders.txt", "hotbar.nbt", "emojicord", "config", "customnpcs/clones", "saves", "launcher", "replay_recordings", "assets/skins", "customnpcs/assets/customnpcs"};
    private final MainLauncherPanel mainPanel;
    private final LauncherFrame launcherFrame;
    private FilesUpdaterThread filesUpdaterThread;

    public Updater(LauncherFrame launcherFrame) {
        this.launcherFrame = launcherFrame;
        this.mainPanel = launcherFrame.mainPanel;
    }

    private static DownloadSource getDownloadSource(String name) {
        return new DownloadSource(String.format("https://aventuros.fr/launcherupdate/files_%s.json", name), String.format("https://aventuros.fr/launcherupdate/%s", name));
    }

    public synchronized void startFilesUpdater(File gameDir) throws IOException {
        if (!this.isRunning()) {
            this.filesUpdaterThread = new FilesUpdaterThread(gameDir);
            this.filesUpdaterThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(File gameDir) throws Throwable {
        this.startFilesUpdater(gameDir);
        this.launcherFrame.invokeLater(this::updateProgress);
        try {
            this.filesUpdaterThread.join();
            if (this.filesUpdaterThread.exception != null) {
                throw this.filesUpdaterThread.exception;
            }
        }
        finally {
            Updater updater = this;
            synchronized (updater) {
                if (this.filesUpdaterThread != null && !this.filesUpdaterThread.isAlive()) {
                    this.filesUpdaterThread = null;
                }
            }
        }
    }

    public synchronized void cancelUpdate() {
        if (this.isRunning()) {
            this.filesUpdaterThread.interrupt();
            try {
                this.filesUpdaterThread.join(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.filesUpdaterThread != null && this.filesUpdaterThread.isAlive();
    }

    private synchronized boolean updateProgress0() {
        if (this.isRunning()) {
            switch (this.filesUpdaterThread.getStatus()) {
                case PREPARING: {
                    this.mainPanel.setInfoText("Pr\u00e9paration...");
                    break;
                }
                case CHECKING: {
                    this.mainPanel.setInfoText("V\u00e9rification des fichiers...");
                    break;
                }
                case DELETING: {
                    this.mainPanel.setInfoText("Suppression des fichiers superflus...");
                    break;
                }
                case DOWNLOADING: {
                    this.mainPanel.setInfoText("T\u00e9l\u00e9chargement des fichiers (" + this.filesUpdaterThread.getFilesDownloaded() + " / " + this.filesUpdaterThread.getTotalFilesToDownload() + ")");
                    this.mainPanel.progressBar.setMaximum(Math.toIntExact(this.filesUpdaterThread.getTotalSizeToDownload() / 1000L));
                    this.mainPanel.progressBar.setValue(Math.toIntExact(this.filesUpdaterThread.getSizeDownloaded() / 1000L));
                }
            }
            return true;
        }
        return false;
    }

    private void updateProgress() {
        if (!this.updateProgress0()) {
            return;
        }
        try {
            Thread.sleep(100L);
            this.launcherFrame.invokeLater(this::updateProgress);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class FilesUpdaterThread
    extends Thread {
        private final LauncherFilesUpdater filesUpdater;
        private Throwable exception;

        public FilesUpdaterThread(File gameDir) throws IOException {
            ArrayList<DownloadSource> sources = new ArrayList<DownloadSource>();
            sources.add(Updater.getDownloadSource("minecraft_base"));
            sources.add(Updater.getDownloadSource("launcher_v2"));
            if (OperatingSystem.CURRENT == OperatingSystem.WINDOWS || OperatingSystem.CURRENT == OperatingSystem.LINUX) {
                sources.add(Updater.getDownloadSource("natives_common_linux_windows"));
                if (OperatingSystem.CURRENT == OperatingSystem.WINDOWS) {
                    sources.add(Updater.getDownloadSource("natives_windows"));
                } else {
                    sources.add(Updater.getDownloadSource("natives_linux"));
                }
            } else {
                sources.add(Updater.getDownloadSource("natives_osx"));
            }
            if (Settings.settings.additionalMods.betterfps) {
                sources.add(Updater.getDownloadSource("betterfps"));
            }
            this.filesUpdater = new LauncherFilesUpdater(gameDir, ignorelist, 12, sources.toArray(new DownloadSource[0]));
        }

        public long getTotalSizeToDownload() {
            return this.filesUpdater.getTotalSizeToDownload();
        }

        public long getSizeDownloaded() {
            return this.filesUpdater.getSizeDownloaded();
        }

        public long getTotalFilesToDownload() {
            return this.filesUpdater.getTotalFilesToDownload();
        }

        public long getFilesDownloaded() {
            return this.filesUpdater.getFilesDownloaded();
        }

        public DownloadStatus getStatus() {
            return this.filesUpdater.getStatus();
        }

        @Override
        public void run() {
            try {
                this.filesUpdater.start();
                if (this.isInterrupted()) {
                    System.out.println("InterruptedException triggered at end of update");
                    throw new InterruptedException();
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }
    }
}

