/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.game;

import com.sun.istack.internal.NotNull;
import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.settings.SavedAccount;
import fr.aventuros.launcher.settings.SavedAccountsList;
import fr.aventuros.launcher.settings.Settings;
import fr.aventuros.launcher.utils.OperatingSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public final class GameLogAnalyser {
    private static final Charset charset = OperatingSystem.CURRENT == OperatingSystem.WINDOWS ? StandardCharsets.ISO_8859_1 : Charset.defaultCharset();
    private static final int maxAllStoreLength = 32768;
    private static final Pattern crashReportStartPattern = Pattern.compile("\\[\\d{2}:\\d{2}:\\d{2}] \\[Client thread/[A-Z]+](?: \\[[A-Z]+])?: \\[[\\w.:]+]: ---- Minecraft Crash Report ----");
    private static final Pattern crashReportEndPattern = Pattern.compile("\\[\\d{2}:\\d{2}:\\d{2}] \\[Client thread/[A-Z]+](?: \\[[A-Z]+])?: \\[[\\w.:]+]: #@!@# Game crashed! Crash report saved to: #@!@# (.*)");
    private static final Pattern restartForUpdatePattern = Pattern.compile("\\[\\d{2}:\\d{2}:\\d{2}] \\[Netty Client IO #\\d+/INFO]: ----- Restart For Update Required -----");
    private static final Pattern restartForUserChangePattern = Pattern.compile("\\[\\d{2}:\\d{2}:\\d{2}] \\[Netty Client IO #\\d+/INFO]: ----- Changing username to ([a-zA-Z0-9_]{3,16}) -----");
    @NotNull
    private LoggingState loggingState = LoggingState.LOGGING_ALL;
    private final StringBuilder builder = new StringBuilder(32768);
    private final LauncherFrame launcherFrame;
    private final BufferedReader reader;

    public GameLogAnalyser(LauncherFrame launcherFrame, InputStream input) {
        this.launcherFrame = launcherFrame;
        this.reader = new BufferedReader(new InputStreamReader(input, charset));
    }

    public void processOutput() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                System.out.println(line);
                this.handleLine(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleLine(String line) {
        if (this.loggingState.noLog) {
            return;
        }
        if (this.loggingState == LoggingState.LOGGING_CRASH_REPORT) {
            Matcher endMatcher = crashReportEndPattern.matcher(line);
            if (endMatcher.matches()) {
                this.builder.append("\nCrash report saved to: ").append(endMatcher.group(1));
                this.loggingState = LoggingState.CRASH_REPORT_ENDED;
            } else {
                this.builder.append(line).append("\n");
            }
        } else {
            if (crashReportStartPattern.matcher(line).matches()) {
                this.loggingState = LoggingState.LOGGING_CRASH_REPORT;
                this.builder.setLength(0);
                this.builder.append("---- Minecraft Crash Report ----\n");
                return;
            }
            if (restartForUpdatePattern.matcher(line).matches()) {
                this.loggingState = LoggingState.RESTART_FOR_UPDATE;
                this.builder.setLength(0);
                return;
            }
            Matcher userChangeMatcher = restartForUserChangePattern.matcher(line);
            if (userChangeMatcher.matches()) {
                this.handleChangeUser(userChangeMatcher.group(1));
            }
            if (this.loggingState == LoggingState.LOGGING_ALL) {
                this.builder.append(line).append("\n");
                if (this.builder.length() > 32768) {
                    this.builder.setLength(0);
                    this.loggingState = LoggingState.IDLE;
                }
            }
        }
    }

    private void handleChangeUser(String newUsername) {
        SavedAccountsList savedAccountsList = Settings.settings.connectedAccounts;
        SavedAccount currentAccount = savedAccountsList.getSelectedAccount();
        if (currentAccount instanceof SavedAccount.CrackedSavedAccount) {
            savedAccountsList.removeAccount(savedAccountsList.selectedIndex);
            SavedAccount.CrackedSavedAccount newSavedAccount = new SavedAccount.CrackedSavedAccount(newUsername);
            savedAccountsList.addAccount(newSavedAccount);
            this.launcherFrame.mainPanel.updateSelectedAccountInfo(newSavedAccount);
        } else {
            JOptionPane.showMessageDialog(this.launcherFrame, "Une migration de pseudo de compte crack a \u00e9t\u00e9 d\u00e9tect\u00e9e, mais le compte s\u00e9lectionn\u00e9 est un compte premium. Impossible de changer le pseudo automatiquement.\nNouveau pseudo : " + newUsername, "Aventuros Launcher - Changement de pseudo", 0);
        }
    }

    public String getValue() {
        return this.builder.toString().trim();
    }

    public LoggingState getLoggingState() {
        return this.loggingState;
    }

    public static enum LoggingState {
        LOGGING_ALL,
        IDLE,
        LOGGING_CRASH_REPORT,
        CRASH_REPORT_ENDED(true, false),
        RESTART_FOR_UPDATE(true, true);

        public final boolean noLog;
        public final boolean knownCloseReason;

        private LoggingState() {
            this(false, false);
        }

        private LoggingState(boolean noLog, boolean knownCloseReason) {
            this.noLog = noLog;
            this.knownCloseReason = knownCloseReason;
        }
    }
}

