/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher.game;

import com.sun.istack.internal.Nullable;
import fr.aventuros.launcher.game.GameLogAnalyser;
import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.gui.OptionFrame;
import fr.aventuros.launcher.gui.panels.CrashPanel;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.OperatingSystem;
import fr.aventuros.mclauncherlib.ClassPathBuilder;
import fr.aventuros.mclauncherlib.utils.files.FileLister;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;

public final class GameLauncher {
    private static final String mainClass = "net.minecraft.launchwrapper.Launch";
    private static final String assetsFolder = "assets";
    private static final String libsFolder = "libs";
    private static final String nativesFolder = "natives";
    private static final String mainJar = "aventuros.jar";
    private static final List<String> specialArgs = Arrays.asList("-XX:-UseAdaptiveSizePolicy", "-XX:+UseConcMarkSweepGC");
    private static final List<String> vmArgs = Arrays.asList("-Dfml.ignoreInvalidMinecraftCertificates=true", "-Dfml.ignorePatchDiscrepancies=true");
    private Process gameProcess;
    private final LauncherFrame launcherFrame;

    public GameLauncher(LauncherFrame launcherFrame) {
        this.launcherFrame = launcherFrame;
    }

    private ProcessBuilder createProcessBuilder(File gameDir, String username, @Nullable String accessToken, @Nullable String uuid) {
        File assetsDir = new File(gameDir, assetsFolder);
        File libsDir = new File(gameDir, libsFolder);
        File nativesDir = new File(gameDir, nativesFolder);
        File mainJarFile = new File(gameDir, mainJar);
        ArrayList<String> command = new ArrayList<String>(8);
        command.add(Constants.javaExecutablePath);
        command.addAll(specialArgs);
        if (OperatingSystem.CURRENT == OperatingSystem.OSX) {
            command.add("-Xdock:name=Aventuros v2");
        }
        command.add("-Djava.library.path=" + nativesDir.getAbsolutePath());
        command.addAll(vmArgs);
        command.addAll(OptionFrame.getRamArguments());
        command.add("-cp");
        command.add(new ClassPathBuilder(new FileLister(libsDir).onlyFiles().withExtension("jar").buildList()).add(mainJarFile).build());
        command.add(mainClass);
        command.add("--username=" + username);
        command.add("--accessToken");
        if (accessToken == null) {
            command.add(username);
        } else {
            command.add(accessToken);
        }
        command.add("--version");
        command.add("1.12.2");
        command.add("--gameDir");
        command.add(gameDir.getAbsolutePath());
        command.add("--assetsDir");
        command.add(assetsDir.getAbsolutePath());
        command.add("--assetIndex");
        command.add("1.12");
        command.add("--userProperties");
        command.add("{}");
        if (uuid != null) {
            command.add("--uuid");
            command.add(uuid);
        }
        command.add("--userType");
        command.add("legacy");
        command.add("--tweakClass");
        command.add("net.minecraftforge.fml.common.launcher.FMLTweaker");
        System.out.printf("Commande enti\u00e8re : %s%n", command);
        return new ProcessBuilder(command).directory(gameDir).redirectErrorStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launch(File gameDir, String username, @Nullable String accessToken, @Nullable String uuid) throws InterruptedException, IOException {
        try {
            GameLauncher gameLauncher = this;
            synchronized (gameLauncher) {
                block13: {
                    if (this.gameProcess == null) break block13;
                    boolean bl = false;
                    return bl;
                }
                this.gameProcess = this.createProcessBuilder(gameDir, username, accessToken, uuid).start();
            }
            long startTime = System.currentTimeMillis();
            GameLogAnalyser logAnalyser = new GameLogAnalyser(this.launcherFrame, this.gameProcess.getInputStream());
            this.launcherFrame.setState(1);
            logAnalyser.processOutput();
            this.gameProcess.waitFor();
            this.launcherFrame.setState(0);
            GameLogAnalyser.LoggingState loggingState = logAnalyser.getLoggingState();
            if (loggingState.knownCloseReason) {
                if (loggingState == GameLogAnalyser.LoggingState.RESTART_FOR_UPDATE) {
                    boolean bl = this.handleRestartForUpdate();
                    return bl;
                }
            } else if (this.gameProcess.exitValue() != 0) {
                File latestLogFile = new File(gameDir, "logs/latest.log");
                this.launcherFrame.setContentPane(new CrashPanel(this.launcherFrame, logAnalyser, startTime > latestLogFile.lastModified() ? null : latestLogFile));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeProcess();
        }
    }

    private boolean handleRestartForUpdate() {
        return JOptionPane.showConfirmDialog(this.launcherFrame, "Le jeu vient d'\u00eatre mis \u00e0 jour et n\u00e9cessite d'\u00eatre relanc\u00e9. Souhaitez-vous le faire maintenant ?", "Aventuros Launcher - Mise \u00e0 jour", 0, 3) == 0;
    }

    public synchronized void closeProcess() {
        if (this.gameProcess != null) {
            if (this.gameProcess.isAlive()) {
                this.gameProcess.destroy();
                boolean exited = false;
                try {
                    exited = this.gameProcess.waitFor(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!exited) {
                    this.gameProcess.destroyForcibly();
                }
            }
            this.gameProcess = null;
        }
    }

    public boolean isRunning() {
        return this.gameProcess != null && this.gameProcess.isAlive();
    }
}

