/*
 * Decompiled with CFR 0.152.
 */
package fr.aventuros.launcher;

import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.aventuros.launcher.gui.LauncherFrame;
import fr.aventuros.launcher.utils.Constants;
import fr.aventuros.launcher.utils.OperatingSystem;
import fr.aventuros.launcher.utils.Utils;
import fr.aventuros.mclauncherlib.UniqueInstanceChecker;
import fr.aventuros.mclauncherlib.utils.ErrorCatcher;
import fr.aventuros.mclauncherlib.utils.FileDownloader;
import fr.theshark34.swinger.Swinger;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.JOptionPane;

public final class Launcher {
    public static final int launcherVersion = 36;
    public static final boolean devMode = false;
    public static final String serverName = "Aventuros v2";
    public static final File defaultGameDir;
    public static final File launcherDir;
    public static final ErrorCatcher errorCatcher;
    private static LauncherFrame launcherFrame;

    private Launcher() {
        throw new AssertionError();
    }

    public static void main(String[] args) {
        Swinger.setSystemLookNFeel();
        Launcher.runPreStartChecks();
        launcherFrame = new LauncherFrame();
        Launcher.init();
        launcherFrame.displayMainPanel();
    }

    private static void runPreStartChecks() {
        UniqueInstanceChecker uniqueInstanceChecker;
        Pattern versionPattern = Pattern.compile("1\\.8\\.0_(\\d+)");
        Matcher versionMatcher = versionPattern.matcher(System.getProperty("java.version"));
        if (!versionMatcher.matches()) {
            Launcher.startError("Le launcher n'est compatible uniquement avec java 8. Merci d'installer cette version depuis le site https://java.com/");
        }
        if (Integer.parseInt(versionMatcher.group(1)) < 241) {
            Launcher.startConfirm("Vous utilisez une version de java inf\u00e9rieure \u00e0 Java 8 Update 241 (8u241). Le jeu ne pourra pas corriger automatiquement la faille \"Bleeding Pipe\" car les versions pr\u00e9c\u00e9dentes ne contiennent pas la fonctionnalit\u00e9 requise.\nPour jouer en toute s\u00e9curit\u00e9, nous vous recommandons d'installer la derni\u00e8re version de java, que vous pouvez t\u00e9l\u00e9charger depuis le site https://java.com/\n\nSouhaitez-vous continuer vers le launcher ? Vous avez \u00e9t\u00e9 pr\u00e9venu, nous ne pourrons \u00eatre tenus pour responsables en cas d'attaque par ce vecteur.", 2);
        }
        if (OperatingSystem.is32Bits && "amd64".equals(System.getProperty("os.arch"))) {
            Launcher.startConfirm("Nous avons d\u00e9tect\u00e9 que vous utilisez la version 32 bits de Java, alors que votre machine est 64 bits.\nPour des performances optimales, nous vous recommandons de d\u00e9sinstaller la version actuelle et d'installer la version 64 bits de Java.\n\nSouhaitez-vous continuer vers le launcher ?", 2);
        }
        if (!(uniqueInstanceChecker = new UniqueInstanceChecker(27072, () -> {
            if (launcherFrame != null) {
                launcherFrame.setState(0);
                launcherFrame.requestFocus();
                launcherFrame.sendToFront();
            }
        })).checkSingleInstance()) {
            System.exit(1);
        }
    }

    private static void initKeystore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        char[] password = "L4tZEw".toCharArray();
        KeyStore customKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream fis = Utils.getRessource("customkeystore.jks").openStream();){
            customKeyStore.load(fis, password);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(customKeyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(customKeyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        SSLContext.setDefault(sslContext);
    }

    private static void init() {
        File oldLauncherFile;
        try {
            Launcher.initKeystore();
        }
        catch (IOException | NullPointerException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            e.printStackTrace();
        }
        if (Launcher.checkLauncherCfg()) {
            System.exit(1);
        }
        if ((oldLauncherFile = new File(launcherDir, "launcher v2.jar")).exists()) {
            oldLauncherFile.delete();
        }
    }

    private static boolean checkLauncherCfg() {
        try {
            JsonObject cfg = JsonParser.parseReader(new FileDownloader("https://aventuros.fr/launcherupdate/launchercfg.json").downloadReader()).getAsJsonObject();
            JsonObject maintenancePart = cfg.getAsJsonObject("maintenance");
            if (maintenancePart.get("active").getAsBoolean()) {
                StringBuilder error = new StringBuilder("Le launcher est actuellement en maintenance.");
                if (maintenancePart.has("should_end") && !(maintenancePart.get("should_end") instanceof JsonNull)) {
                    error.append("\nElle devrait se terminer ").append(maintenancePart.get("should_end").getAsString());
                }
                if (maintenancePart.has("additional_message") && !(maintenancePart.get("additional_message") instanceof JsonNull)) {
                    error.append("\n").append(maintenancePart.get("additional_message").getAsString());
                }
                Launcher.startError(error.toString());
                return true;
            }
            int newestVersion = cfg.get("version").getAsInt();
            if (newestVersion > 36) {
                return Launcher.downloadNewLauncherVersion();
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            Launcher.startError("Impossible de se connecter au serveur d'Aventuros. Veuillez v\u00e9rifier votre connexion internet, ou r\u00e9essayer plus tard.\n" + e);
            return true;
        }
    }

    private static boolean downloadNewLauncherVersion() {
        File file;
        try {
            file = new File(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (file.isFile()) {
            if (!file.getAbsolutePath().endsWith(".jar")) {
                try {
                    Desktop.getDesktop().browse(new URI("https://aventuros.fr/#download"));
                }
                catch (IOException | URISyntaxException e) {
                    e.printStackTrace();
                }
                Launcher.startError("Une mise \u00e0 jour du launcher est disponible, mais il est impossible de l'installer automatiquement avec cette version du launcher.\nMerci de la t\u00e9l\u00e9charger manuellement depuis le site pour pouvoir continuer \u00e0 jouer.");
                return true;
            }
            String url = "https://aventuros.fr/download/v2/Aventuros%20launcher.jar";
            try {
                new FileDownloader(url).downloadToFile(file);
                Runtime.getRuntime().exec(new String[]{Constants.javaExecutablePath, "-jar", file.getAbsolutePath()});
                return true;
            }
            catch (IOException e) {
                Launcher.startError("Impossible de t\u00e9l\u00e9charger la mise \u00e0 jour du launcher.\n" + e);
            }
        }
        return false;
    }

    private static void startError(String message) {
        JOptionPane.showMessageDialog(null, message, "Erreur - Aventuros Launcher", 0);
        System.exit(1);
    }

    private static void startConfirm(String message, int messageType) {
        if (JOptionPane.showConfirmDialog(null, message, "Aventuros Launcher", 0, messageType) == 1) {
            System.exit(1);
        }
    }

    static {
        switch (OperatingSystem.CURRENT) {
            case WINDOWS: {
                defaultGameDir = new File(System.getProperty("user.home") + "\\AppData\\Roaming\\." + serverName);
                break;
            }
            case OSX: {
                defaultGameDir = new File(System.getProperty("user.home") + "/Library/Application Support/" + serverName);
                break;
            }
            default: {
                defaultGameDir = new File(System.getProperty("user.home") + "/." + serverName);
            }
        }
        launcherDir = new File(defaultGameDir, "launcher");
        errorCatcher = new ErrorCatcher("Aventuros Launcher", "launcher", new File(launcherDir, "error-reports"));
    }
}

